package cn.com.duiba.tuia.adx.center.api.constant.story.tree;

import com.google.common.collect.Lists;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;

/**
 * [深度互动故事完整性]果树类型枚举
 *
 * @author zhangbaiqiang
 * @date 2019-06-03
 */
public enum TreeType {

    NORMAL(1, "普通", 1),
    COCONUT(2, "椰子红包树",2),
    LOTUS(3, "蓬蓬红包树", 3),
    MUSHROOM(4, "蘑菇红包树",4),
    ;

    private Integer type;

    private String desc;

    private Integer sort;

    TreeType(Integer type, String desc, Integer sort) {
        this.type = type;
        this.desc = desc;
        this.sort = sort;
    }

    /**
     * 获取果树类型枚举
     *
     * @param type 果树类型
     * @return 枚举
     */
    public static TreeType valueOf(Integer type) {
        for (TreeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 获取下一棵数
     * @param type 树的类型
     * @return 枚举
     */
    public static TreeType getNextTree(Integer type) {
        if (type == null) {
            return NORMAL;
        }
        List<TreeType> treeTypeList = Lists.newArrayList(values());
        treeTypeList.sort(Comparator.comparingInt(TreeType::getSort));
        int index = -1;
        for (TreeType tree : treeTypeList) {
            index++;
            if (type.equals(tree.getType())) {
                break;
            }
        }
        if (index >= treeTypeList.size() - 1) {
            return null;
        }
        return treeTypeList.get(index + 1);
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }
}
