package cn.com.duiba.tuia.adx.center.api.dto;

import java.io.Serializable;
import java.util.List;

public class HotGuessDto extends RuleConfigDto implements Serializable {
    private static final long serialVersionUID = 351769612542276707L;

    /**
     * 赛事记录
     */
    private List<HotMessage> hotMessages;

    public List<HotMessage> getHotMessages() {
        return hotMessages;
    }

    public void setHotMessages(List<HotMessage> hotMessages) {
        this.hotMessages = hotMessages;
    }

    public static class HotMessage implements Serializable {
        private static final long serialVersionUID = 2496569287992074161L;

        /**
         * 比赛ID
         */
        private Long id;
        /**
         * 赛事名称
         */
        private String hotTitle;
        /**
         * 主队名称
         */
        private String homeTeamName;
        /**
         * 主队logo
         */
        private String homeTeamLogoUrl;
        /**
         * 客队名称
         */
        private String visitingTeamName;
        /**
         * 客队logo
         */
        private String visitingTeamLogoUrl;
        /**
         * 开奖时间
         */
        private String startAwardTime;

        /**
         * 开赛时间
         */
        private String startGameTime;

        /**
         * 是否有平局，默认没有
         */
        private boolean draw;

        /**
         * 动态赔率，默认是
         */
        private boolean dynamicOdds;

        /**
         * 选项配置
         */
        private List<Options> options;

        /**
         * 结果
         */
        private Result result;

        /**
         * 是否是热门，默认不是
         */
        private boolean hot;

        /**
         * 开奖状态 0 押注中 1 押注截止 2 已开奖
         */
        private Integer guessStatus;

        public Integer getGuessStatus() {
            return guessStatus;
        }

        public void setGuessStatus(Integer guessStatus) {
            this.guessStatus = guessStatus;
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getHotTitle() {
            return hotTitle;
        }

        public void setHotTitle(String hotTitle) {
            this.hotTitle = hotTitle;
        }

        public String getHomeTeamName() {
            return homeTeamName;
        }

        public void setHomeTeamName(String homeTeamName) {
            this.homeTeamName = homeTeamName;
        }

        public String getHomeTeamLogoUrl() {
            return homeTeamLogoUrl;
        }

        public void setHomeTeamLogoUrl(String homeTeamLogoUrl) {
            this.homeTeamLogoUrl = homeTeamLogoUrl;
        }

        public String getVisitingTeamName() {
            return visitingTeamName;
        }

        public void setVisitingTeamName(String visitingTeamName) {
            this.visitingTeamName = visitingTeamName;
        }

        public String getVisitingTeamLogoUrl() {
            return visitingTeamLogoUrl;
        }

        public void setVisitingTeamLogoUrl(String visitingTeamLogoUrl) {
            this.visitingTeamLogoUrl = visitingTeamLogoUrl;
        }

        public String getStartAwardTime() {
            return startAwardTime;
        }

        public void setStartAwardTime(String startAwardTime) {
            this.startAwardTime = startAwardTime;
        }

        public String getStartGameTime() {
            return startGameTime;
        }

        public void setStartGameTime(String startGameTime) {
            this.startGameTime = startGameTime;
        }

        public boolean getDraw() {
            return draw;
        }

        public void setDraw(boolean draw) {
            this.draw = draw;
        }

        public boolean getDynamicOdds() {
            return dynamicOdds;
        }

        public void setDynamicOdds(boolean dynamicOdds) {
            this.dynamicOdds = dynamicOdds;
        }

        public List<Options> getOptions() {
            return options;
        }

        public void setOptions(List<Options> options) {
            this.options = options;
        }

        public Result getResult() {
            return result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public boolean getHot() {
            return hot;
        }

        public void setHot(boolean hot) {
            this.hot = hot;
        }
    }

    public static class Options implements Serializable {
        private static final long serialVersionUID = 7265327888489726441L;

        private Integer id;
        /**
         * 选项描述
         */
        private String  optionDesc;
        /**
         * 奖金池
         */
        private Double  bonusPool;
        /**
         * 赔率
         */
        private Double  odds;

        /**
         * 展示赔率
         */
        private Double showOdds;


        public Double getShowOdds() {
            return showOdds;
        }

        public void setShowOdds(Double showOdds) {
            this.showOdds = showOdds;
        }

        public Integer getId() {
            return id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getOptionDesc() {
            return optionDesc;
        }

        public void setOptionDesc(String optionDesc) {
            this.optionDesc = optionDesc;
        }

        public Double getBonusPool() {
            return bonusPool;
        }

        public void setBonusPool(Double bonusPool) {
            this.bonusPool = bonusPool;
        }

        public Double getOdds() {
            return odds;
        }

        public void setOdds(Double odds) {
            this.odds = odds;
        }
    }

    public static class Result implements Serializable {
        private static final long serialVersionUID = -6473646289651447340L;

        /**
         * 结果
         */
        private Integer result;
        /**
         * 主队比分
         */
        private Integer homeScore;
        /**
         * 客队比分
         */
        private Integer visitingScore;

        public Integer getResult() {
            return result;
        }

        public void setResult(Integer result) {
            this.result = result;
        }

        public Integer getHomeScore() {
            return homeScore;
        }

        public void setHomeScore(Integer homeScore) {
            this.homeScore = homeScore;
        }

        public Integer getVisitingScore() {
            return visitingScore;
        }

        public void setVisitingScore(Integer visitingScore) {
            this.visitingScore = visitingScore;
        }
    }
}
