/**
 * Project Name:activity-center-api
 * File Name:VirtualGoodsInfoDto.java
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto
 * Date:2017年11月13日下午5:15:48
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.adx.center.api.dto;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import cn.com.duiba.tuia.adx.center.api.common.BaseDto;
import cn.com.duiba.tuia.adx.center.api.constant.AlipayType;
import com.alibaba.fastjson.JSON;

import com.google.common.collect.Maps;

/**
 * ClassName:VirtualGoodsInfoDto <br/>
 * Function: 虚拟商品. <br/>
 * Date:     2017年11月13日 下午5:15:48 <br/>
 * @author   guyan
 * @version  
 * @see 	 
 */
public class VirtualGoodsInfoDto extends BaseDto {

    /**序列号*/
    private static final long serialVersionUID = -3081469676034835097L;
    
    /**虚拟商品类型, API充值 0 券码充值 1 账号充值 2*/
    private  Integer virtualType;
    
    /**虚拟商品子类型*/
    private Integer  subType;
    
    /**奖品库id*/
    private Long     prizeId;
    
    /**扩展信息字段*/
    private String   extInfo;
    
    
    /**
     * 
     * Creates a new instance of VirtualGoodsInfoDto.
     *
     */
    public VirtualGoodsInfoDto() {
        super();
    }
    
    /**
     * 
     * Creates a new instance of VirtualGoodsInfoDto.
     *
     * @param extInfo
     */
    public VirtualGoodsInfoDto(String extInfo) {
        super();
        this.extInfo = extInfo;
    }
       
    public Integer getVirtualType() {
        return virtualType;
    }

    
    public void setVirtualType(Integer virtualType) {
        this.virtualType = virtualType;
    }

    
    public Integer getSubType() {
        return subType;
    }

    
    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    
    public Long getPrizeId() {
        return prizeId;
    }

    
    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    
    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }
    
    public void setExtInfoByValue(PrizeDto dto){ 
        if (dto==null) {
            return;
        }
        Integer accountSwitch=dto.getAccountSwitch();
        List<AccountRechargeDto> list=dto.getAccountRechargeDto();
        HashMap<String,Object> map = null;
        if (AlipayType.VIRTUAL_API.getType().equals(this.getVirtualType())) {
           map=new HashMap<>(3);
           ApiRechargeDto apiDto=dto.getApiRechargeDto();
           map.put("apiRecharge", apiDto);
           map.put("accountSwitch", accountSwitch);
            map.put("accountInfo", BaseDto.isEmpty(list) ? Collections.emptyList() : list);
        }else if (AlipayType.VIRTUAL_TICKET.getType().equals(this.getVirtualType())) {
            map=new HashMap<>(1);
            CouponsCodeDto couponsDto=dto.getCouponsCodeDto();
            map.put("coupons", couponsDto);
        }else if (AlipayType.VIRTUAL_ACCOUNT.getType().equals(this.getVirtualType())) {
            map=new HashMap<>(2);
            map.put("accountSwitch", accountSwitch);
            map.put("accountInfo", BaseDto.isEmpty(list) ? Collections.emptyList() : list);
        } else if (AlipayType.VIRTUAL_RED_PACKET.getType().equals(this.getVirtualType())) {
            map=new HashMap<>(1);
            map.put("redPacket", dto.getRedPacket());
        }else if(AlipayType.JUMP_QUICK_APPLICATION.getType().equals(this.getVirtualType())){
            map = Maps.newHashMap();
            map.put("quickApplicationRecharge", dto.getQuickApplicationRechargeDto());
        }else if(AlipayType.JUMP_H5.getType().equals(this.getVirtualType())){
            map = Maps.newHashMap();
            map.put("h5Recharge", dto.getH5RechargeDto());
        }
        this.setExtInfo(JSON.toJSONString(map));
    }
}

