package cn.com.duiba.tuia.adx.center.api.dto.adx.audit;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * adx 审核dto
 *
 * @author peanut.huang
 * @date 2020/2/4 14:21
 */
@Data
public class AdxAuditDto implements Serializable {
    private static final long serialVersionUID = 4112562604421633955L;

    /**
     * adx 类型
     */
    private Integer adxType;

    /**
     * 广告类型id
     */
    private Long adTypeId;

    /**
     * adx 广告样式id
     */
    private Long adStyleId;

    /**
     * 广告id
     */
    private Long advertId;

    /**
     * 广告名称
     */
    private String advertName;

    /**
     * 素材id
     */
    private Long advertMaterialId;

    /**
     * 广告主id
     */
    private Long advertiserId;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 第三方广告主id
     **/
    private Long threePartyAdvertiserId;

    /**
     * 标题
     */
    private String title;

    /**
     * 描述
     */
    private String desc;

    /**
     * 落地页地址
     */
    private String landingUrl;

    /**
     * 视频对象
     */
    private List<AdxAuditVideoDto> videoDtoList;

    /**
     * 图片对象
     */
    private List<AdxAuditImageDto> imageList;
}
