package cn.com.duiba.tuia.adx.center.api.dto.plant.configV2.mission;

import cn.com.duiba.tuia.adx.center.api.constant.PlantMissionType;

import java.io.Serializable;
import java.util.List;

/**
 * [种红包V2]任务项
 *
 * @author zhangbaiqiang
 * @date 2018/12/17
 */
public class MissionItem implements Serializable {
    private static final long serialVersionUID = 4603853245007367844L;

    /**
     * 任务描述
     */
    private String desc;

    /**
     * 奖励描述
     */
    private String prizeDesc;

    /**
     * 图片链接
     */
    private String picUrl;

    /**
     * 任务类型
     *
     * {@link PlantMissionType}
     */
    private String type;

    /**
     * 循环类型
     */
    private String cycleType;

    /**
     * 第几天的任务
     */
    private Integer showDay;

    /**
     * 起始任务展示(包含)
     */
    private Integer startShowDay;

    /**
     * 结束任务展示(包含)
     */
    private Integer endShowDay;

    /**
     * 是否预览
     */
    private Boolean preview;

    /**
     * 是否必出现金
     */
    private Boolean mustCash;

    /**
     * 在第几天预览
     */
    private Integer previewDay;

    /**
     * 配置的styleType
     *
     */
    private Long styleType;

    /**
     * 排序，数值越大越靠前
     */
    private Integer order;

    /**
     * 任务条件
     */
    private List<MissionCondition> condition;

    /**
     * 任务奖励
     */
    private List<MissionPrize> prize;

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getPrizeDesc() {
        return prizeDesc;
    }

    public void setPrizeDesc(String prizeDesc) {
        this.prizeDesc = prizeDesc;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getShowDay() {
        return showDay;
    }

    public void setShowDay(Integer showDay) {
        this.showDay = showDay;
    }

    public Boolean getPreview() {
        return preview;
    }

    public void setPreview(Boolean preview) {
        this.preview = preview;
    }

    public Boolean getMustCash() {
        return mustCash;
    }

    public void setMustCash(Boolean mustCash) {
        this.mustCash = mustCash;
    }

    public Integer getPreviewDay() {
        return previewDay;
    }

    public void setPreviewDay(Integer previewDay) {
        this.previewDay = previewDay;
    }

    public Long getStyleType() {
        return styleType;
    }

    public void setStyleType(Long styleType) {
        this.styleType = styleType;
    }

    public List<MissionCondition> getCondition() {
        return condition;
    }

    public void setCondition(List<MissionCondition> condition) {
        this.condition = condition;
    }

    public List<MissionPrize> getPrize() {
        return prize;
    }

    public void setPrize(List<MissionPrize> prize) {
        this.prize = prize;
    }

    public String getCycleType() {
        return cycleType;
    }

    public void setCycleType(String cycleType) {
        this.cycleType = cycleType;
    }

    public Integer getStartShowDay() {
        return startShowDay;
    }

    public void setStartShowDay(Integer startShowDay) {
        this.startShowDay = startShowDay;
    }

    public Integer getEndShowDay() {
        return endShowDay;
    }

    public void setEndShowDay(Integer endShowDay) {
        this.endShowDay = endShowDay;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }
}
