package cn.com.duiba.tuia.adx.center.api.dto.region;

import cn.com.duiba.tuia.adx.center.api.constant.SubType;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 描述：活动区块
 *
 * @author weny.cai
 * @date 2018/9/20 10:06
 **/
public class ActivityRegionBlockDto implements Serializable{

    private Long id;

    /**
     * 图片
     */
    private String image;

    /**
     * 区块类型
     */
    private Integer blockType;

    /**
     * 关联IDS
     */
    private String relationIds;

    /**
     * 区块名称
     */
    private String blockName;

    /**
     * 替补类型
     */
    private Integer subType;

    /**
     * 替补内容
     */
    private String subContent;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Integer getBlockType() {
        return blockType;
    }

    public void setBlockType(Integer blockType) {
        this.blockType = blockType;
    }

    public String getRelationIds() {
        return relationIds;
    }

    public void setRelationIds(String relationIds) {
        this.relationIds = relationIds;
    }

    public String getBlockName() {
        return blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public List<Long> getRelationIdsList(){
        try{
            List<Long> relationIdsList = Lists.newArrayList();
            String relationIds = this.getRelationIds();
            if(StringUtils.isNotBlank(relationIds)){
                String[] arr = relationIds.split(",");
                for (String relationId : arr) {
                    relationIdsList.add(Long.valueOf(relationId));
                }
            }
            return relationIdsList;
        }catch (Exception e){
            return Lists.newArrayList();
        }

    }

    public List<Long> getContentIdsList(){
        try{
            List<Long> contentIdsList = Lists.newArrayList();
            String content = this.getSubContent();
            if(!SubType.URL.getType().equals(this.getSubType())&&StringUtils.isNotBlank(content)){
                String[] arr = content.split(",");
                for (String contentId : arr) {
                    contentIdsList.add(Long.valueOf(contentId));
                }
            }
            return contentIdsList;
        }catch (Exception e){
            return Lists.newArrayList();
        }
    }


}
