package cn.com.duiba.tuia.adx.center.api.dto.req;

import cn.com.duiba.tuia.adx.center.api.bean.enums.adx.TuiaStyleTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 创意分页
 *
 * @author weny.cai
 * @date 2018/12/3 14:51
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MaterialUnitPageV2Req extends ReqPageQuery {

    private static final long serialVersionUID = -8182251310802108288L;

    /**
     * 创意计划搜索关键词
     */
    private String ideaSearchKey;

    /**
     * 资源搜索关键词
     */
    private String resourceSearchKey;

    /**
     * 推广组搜索关键词
     */
    private String groupSearchKey;

    /**
     * 创意素材搜索关键词
     */
    private String materialSearchKey;

    /**
     * 创意样式 1-单图 2-两图 3-三图 4-视频 99-未知
     * @see TuiaStyleTypeEnum
     */
    private Integer styleType;

    /**
     * 创意素材类型 0-人工素材 1-算法素材
     */
    private Integer materialType;

    /**
     * 比例区间
     */
    private Integer rateType;

}
