package cn.com.duiba.tuia.adx.center.api.dto.staticpage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel
public class VerifyResultDto {

    private Long id;

    /**
     * 平台Id
     */
    @ApiModelProperty(value = "平台Id")
    private Integer platformType;
    /**
     * 平台名称
     */
    @ApiModelProperty(value = "平台名称")
    private String platformName;
    /**
     * 页面url
     */
    @ApiModelProperty(value = "页面url")
    private String tuiaUrl;

    /**
     * 平台审核后给出的url
     */
    @ApiModelProperty(value = "平台审核后给出的url")
    private String thirdUrl;

    /**
     * 审核状态 （1：送审中，2-审核通过 3-审核拒绝）
     */
    @ApiModelProperty(value = "审核状态 （1：送审中，2-审核通过 3-审核拒绝）")
    private Integer lastStatus;

    /**
     * 最后一次送审时间
     */
    @ApiModelProperty(value = "最后一次送审时间")
    private Date lastSendGmt;

    /**
     * 最后审核回调时间
     */
    @ApiModelProperty(value = "最后审核回调时间")
    private Date lastCallbackGmt;

    /**
     * 审核拒绝原因
     */
    @ApiModelProperty(value = "审核拒绝原因")
    private String refuseReason;

    public Integer getPlatformType() {
        return platformType;
    }

    public void setPlatformType(Integer platformType) {
        this.platformType = platformType;
    }

    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getTuiaUrl() {
        return tuiaUrl;
    }

    public void setTuiaUrl(String tuiaUrl) {
        this.tuiaUrl = tuiaUrl;
    }

    public String getThirdUrl() {
        return thirdUrl;
    }

    public void setThirdUrl(String thirdUrl) {
        this.thirdUrl = thirdUrl;
    }

    public Integer getLastStatus() {
        return lastStatus;
    }

    public void setLastStatus(Integer lastStatus) {
        this.lastStatus = lastStatus;
    }

    public Date getLastSendGmt() {
        return lastSendGmt;
    }

    public void setLastSendGmt(Date lastSendGmt) {
        this.lastSendGmt = lastSendGmt;
    }

    public Date getLastCallbackGmt() {
        return lastCallbackGmt;
    }

    public void setLastCallbackGmt(Date lastCallbackGmt) {
        this.lastCallbackGmt = lastCallbackGmt;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "VerifyResultDto{" +
                "id=" + id +
                ", platformType=" + platformType +
                ", platformName='" + platformName + '\'' +
                ", tuiaUrl='" + tuiaUrl + '\'' +
                ", thirdUrl='" + thirdUrl + '\'' +
                ", lastStatus=" + lastStatus +
                ", lastSendGmt=" + lastSendGmt +
                ", lastCallbackGmt=" + lastCallbackGmt +
                ", refuseReason='" + refuseReason + '\'' +
                '}';
    }
}
