package cn.com.duiba.tuia.adx.center.api.log;

import com.alibaba.fastjson.JSONObject;

/**
 * ClassName: Log <br/>
 * Function: 日志包装类. <br/>
 * json格式日志继承此类.<br/>
 * date: 2017年2月23日 下午6:52:53 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
public class Log {

    private JSONObject json;

    /**
     * Creates a new instance of Log.
     *
     */
    public Log() {
        this.json = new JSONObject();
    }

    /**
     * toJSONString:(转换为json格式). <br/>
     * @return String
     */
    public String toJSONString() {
        return json.toJSONString();
    }

    /**
     * getJson:(获取JSONObject). <br/>
     * @return
     */
    public JSONObject getJson() {
        return json;
    }

    /**
     * setJson:(设置JSONObject). <br/>
     * @param json
     */
    public void setJson(JSONObject json) {
        this.json = json;
    }

    /**
     * setChild:(设置子结点). <br/>
     * @param nodeName
     * @param log
     * @return Log
     */
    public Log setChild(String nodeName, Log log) {
        this.json.put(nodeName, log.getJson());
        return this;
    }

    /**
     * put:(在当前层级添加一条属性). <br/>
     * @param key
     * @param value
     * @return Log
     */
    public Log put(String key, Object value) {
        this.json.put(key, value);
        return this;
    }
}
