package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.common.PageDto;
import cn.com.duiba.tuia.adx.center.api.dto.ActivityWinOrderDto;
import cn.com.duiba.tuia.adx.center.api.dto.consumer.req.BalanceWithdrawReq;
import cn.com.duiba.tuia.adx.center.api.dto.req.ReqAliOrderQuery;
import cn.com.duiba.tuia.adx.center.api.exception.ActivityCenterException;

import java.util.Date;

/**
 * Created by wubo on 2017/7/10.
 */
@AdvancedFeignClient
public interface RemoteActivityWinOrderService {

    PageDto<ActivityWinOrderDto> selectWinOrderPage4Manager(ReqAliOrderQuery req);

    ActivityWinOrderDto selectByOrderId4Manager(Date start, Date end, String orderId);

    ActivityWinOrderDto selectByOrderId4User(String deviceId, String orderId);

    void updateByOrderId4Manager(ActivityWinOrderDto activityWinOrderDto) throws ActivityCenterException;

    /**
     * 现金钱包提现
     *
     * @param req
     * @return
     */
    ActivityWinOrderDto cashWithdraw(BalanceWithdrawReq req) throws ActivityCenterException;

    /**
     * 现金钱包提现 - 管理端重试
     *
     * @param date
     * @param orderId
     * @param aliName
     * @param aliAccount
     * @return
     */
    ActivityWinOrderDto retryCashWithdraw(Date date, String orderId, String aliName, String aliAccount) throws ActivityCenterException;
}
