package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 反抄袭服务
 *
 * @author zhangbaiqiang
 * @date 2018/7/25
 */
@AdvancedFeignClient
public interface RemoteAntiPlagiarismService {

    /**
     * 生成访问秘钥
     *
     * @param length 秘钥长度，默认6位
     * @param expireMinutes 过期时间(默认10分钟)，分钟
     * @return 访问秘钥
     */
    String generateAccessKey(Integer length, Integer expireMinutes);

    /**
     * 校验访问秘钥是否有效
     *
     * @return true.有效 false.无效
     */
    Boolean isAccessKeyValid(String accessKey);
}
