/**
 * Project Name:activity-center-api<br>
 * File Name:RemoteEntranceStaticService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.remoteservice<br>
 * Date:2017年3月31日下午5:06:59<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.adx.center.api.remoteservice;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.EntranceDataDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteEntranceStaticService <br/>
 * date: 2017年3月31日 下午5:06:59 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteEntranceStaticService {

    /**
     * 获取活动维度浮标的曝光PV,UV及点击的PV,UV数据,发券量. 支持按日期，批量查询
     *
     * @param start the start
     * @param end the end
     * @param activityIds 活动ids
     * @return the dubbo result< page dto< activity buoy data dto>>
     */
    DubboResult<List<EntranceDataDto>> selectActBuoyDataList(Date start, Date end, List<Long> activityIds);

     /**
     * 获取活动维度浮标的曝光PV,UV及点击的PV,UV数据，发券量. 支持按日期，
     * 批量查询
     * @param start the start
     * @param end the end
     * @param activityIds 活动ids
     * @return the dubbo result< page dto< activity buoy data dto>>
     */
    DubboResult<Map<Long, EntranceDataDto>> selectActBuoyDataMap(Date start, Date end, List<Long> activityIds);

    /**
     * 查询广告位维度返回拦截到各种页面上的发券量，支持按日期，批量.
     *
     * @param start the start
     * @param end the end
     * @param slotIds the slot ids
     * @return the dubbo result< page dto< activity buoy data dto>>
     */
    DubboResult<List<EntranceDataDto>> selectSlotReturnDataList(Date start, Date end, List<Long> slotIds);

    /**
     * 查询广告位维度返回拦截到各种页面上的发券量，支持按日期，批量.
     *
     * @param start the start
     * @param end the end
     * @param slotIds the slot ids
     * @return the dubbo result< page dto< activity buoy data dto>>
     */
    DubboResult<Map<Long, EntranceDataDto>> selectSlotReturnDataMap(Date start, Date end, List<Long> slotIds);

    /**
     * 查询广告位维度返回拦截到各种页面上的每小时发券量.
     *
     * @param start the start
     * @param end the end
     * @param slotId 待查询的广告位
     * @param isHourAccuracy 是否是小时精度的数据，不是则按日期粒度统计
     * @return the dubbo result< list< activity buoy data dto>>
     */
    DubboResult<List<EntranceDataDto>> selectSlotReturnHourData(Date start, Date end, Long slotId, Boolean isHourAccuracy);

}
