package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.UnicomIntegralLessDTO;

/**
 * 联通用户积分不足记录服务
 * @author miaohongshuai
*/
@AdvancedFeignClient
public interface RemoteUnicomIntegralLessService {

    /**
     * 插入 联通用户积分不足记录
     * @param unicomIntegralLessDTO
     * @return
     */
    boolean insertUnicomIntegralLess(UnicomIntegralLessDTO unicomIntegralLessDTO);

    /**
     * 判断设备号的剩余积分是否不足一次活动参与
     * @param deviceId
     * @param activityJointIntegral 这次活动参与一次需要扣除的积分
     * @return
     */
    boolean deviceIdIsIntegralLess(String deviceId, Integer activityJointIntegral);
}
