package cn.com.duiba.tuia.adx.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.req.adx.AdxSuccBidInfo;

/**
 * ADX出价成功信息远程服务类
 *
 * @author weny.cai
 * @date 2018/12/6 14:54
 **/
@AdvancedFeignClient
public interface RemoteAdxSuccBidService {

    /**
     * 竞价
     * @param adxRid
     * @return
     */
    AdxSuccBidInfo getAdxSuccBidInfo(String adxRid);

    @Deprecated
    AdxSuccBidInfo getAdxSuccBidInfoFromRedis(String adxRid);

    /**
     * 保存结果对象到redis中
     * @param adxSuccBidInfo
     * @return
     */
    @Deprecated
    boolean saveToRedis(AdxSuccBidInfo adxSuccBidInfo);

    /**
     * 保存结果对象到DB中,现在存放到hbase中
     * @param adxSuccBidInfo
     * @return
     */
    boolean saveToDB(AdxSuccBidInfo adxSuccBidInfo);

}
