package cn.com.duiba.tuia.adx.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.bean.response.DeliveryGroupDTO;
import cn.com.duiba.tuia.adx.center.api.dto.adx.*;
import cn.com.duiba.tuia.adx.center.api.dto.crowd.CrowdBindDTO;
import cn.com.duiba.tuia.adx.center.api.dto.req.ReqPageQuery;

import java.util.List;

@AdvancedFeignClient
public interface RemoteInitLocalCacheService {

    /**
     * 查询所有有效的资源位信息
     * @return
     */
    List<ResourceLocationDto> getAllValidResourceLocations(ReqPageQuery reqPageQuery);

    /**
     * 查询所有有用的排期单信息
     * @param reqPageQuery
     * @return
     */
    List<PmpDealOrderDTO> getAllValidPmpDealOrders(ReqPageQuery reqPageQuery);

    /**
     * 查询所有有效的广告位类型信息
     * @param reqPageQuery
     * @return
     */
    List<AdvertisingSpaceTypeDto> getAllValidAdvertisingSpaceTypes(ReqPageQuery reqPageQuery);

    /**
     * 查询所有有效的广告样式信息
     * @param pageQuery
     * @return
     */
    List<AdvertisingSpaceStyleDetailDto> getAllValidAdvertisingSpaceStyles(ReqPageQuery pageQuery);

    /**
     * 查询所有的策略组信息
     * @param resourceLocationIds
     * @return
     */
    List<DeliveryGroupDTO> getAllValidDeliveryGroups(List<Long> resourceLocationIds);

    /**
     * 查询所有有效的人群包信息
     * @return
     */
    List<CrowdBindDTO> getAllValidCrowdBinds(ReqPageQuery pageQuery);

    /**
     * 查询所有有效的广告素材样式信息
     * @param pageQuery
     * @return
     */
    List<AdvertisingSpaceStyleMaterialDto> getAllValidAdvertisingSpaceStyleMaterials(ReqPageQuery pageQuery);

    /**
     * 查询所有有效的创意信息
     * @return
     */
    List<ResourceIdeaDto> getAllValidResourceIdeas(List<Long> resourceLocationIds);
}
