package cn.com.duiba.tuia.adx.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.bean.enums.ActTagGroupEnum;
import cn.com.duiba.tuia.adx.center.api.bean.enums.TagBusinessEnum;
import cn.com.duiba.tuia.adx.center.api.bean.enums.TagRelationTypeEnum;
import cn.com.duiba.tuia.adx.center.api.common.PageDto;
import cn.com.duiba.tuia.adx.center.api.dto.req.ReqPageQuery;
import cn.com.duiba.tuia.adx.center.api.dto.tag.*;
import cn.com.duiba.tuia.adx.center.api.dto.tag.son.OCRSlotKeyDTO;
import cn.com.duiba.tuia.adx.center.api.dto.tag.son.SlotKeyTagDTO;
import cn.com.duiba.tuia.adx.center.api.exception.ActivityCenterException;

import java.util.List;
import java.util.Map;

/**
 * 标签库
 * B端接口，C端请另起
 */
@AdvancedFeignClient
public interface RemoteTagService {

    /**
     * 根据标签组获取标签
     * @param groupIds 若为空则查询全部
     */
    List<TagGroupDTO> getTagByGroup(List<Long> groupIds);

    /**
     * 添加标签
     */
    void addTag(TuiaTagDTO dto) throws ActivityCenterException;

    /**
     * 标签排序
     */
    void tagSort(List<Long> tagIds, Long tagGroupId) throws ActivityCenterException;

    /**
     * 删除标签
     * 校验标签是否仍在使用
     */
    void deleteTag(Long tagId) throws ActivityCenterException;

    /**
     * 添加标签组
     */
    void addTagGroup(TagGroupDTO dto) throws ActivityCenterException;


    Long addTagGroupReturnId(TagGroupDTO dto) throws ActivityCenterException;

    /**
     * 标签组排序
     */
    void tagGroupSort(List<Long> tagGroupIds) throws ActivityCenterException;

    /**
     * 删除标签组
     * 校验标签组内标签是否在使用
     */
    void deleteTagGroup(Long tagGroupId) throws ActivityCenterException;

    /**
     * 查询标签组
     * @param name
     * @return
     */
    List<TagGroupDTO> getTagGroup4DropDown(String name);

    /**
     * 根据大类查询标签详情
     * @param categoryIds 不传则查全部
     * @return
     */
    List<TagGroupCategoryDTO> getCategoryGroupTag(List<Long> categoryIds);

    /**
     * 添加标签大类
     * @param req
     */
    void addCategory(TagGroupCategoryDTO req) throws ActivityCenterException;

    /**
     * 标签大类增加标签组
     * @param req
     */
    void categoryAddGroup(TagGroupRelationDTO req) throws ActivityCenterException;

    /**
     * 标签大类删除标签组
     * @param req
     */
    void categoryDelGroup(TagGroupRelationDTO req) throws ActivityCenterException;

    /**
     * 删除标签大类
     * @param categoryId
     */
    void deleteCategory(Long categoryId) throws ActivityCenterException;

    /**
     * 标签大类内标签组排序
     */
    void tagCategoryGroupSort(List<TagCategoryGroupDTO> tagGroups, Long categoryId) throws ActivityCenterException;

    /**
     * 修改标签组名称
     * @param req
     */
    void updateTagGroup(TagGroupDTO req) throws ActivityCenterException;

    /**
     * 修改标签名称
     * @param req
     */
    void updateTag(TuiaTagDTO req) throws ActivityCenterException;

    /**
     * 绑定标签
     */
    void bindTag(TagBindDTO dto) throws ActivityCenterException;

    /**
     * 获取所有标签信息
     * @param ids
     * @param type：1主2副标题，3奖品  {@link TagBusinessEnum}
     * @return
     */
    Map<Long, List<Long>> getTagMap(List<Long> ids, Integer type);

    Map<Long, List<String>> getTagNameMap(List<Long> ids, Integer type);

    Map<Long, List<String>> getTagNames(List<Long> ids, Integer groupType, Integer relationType);

    Map<Long, Map<Long,String>> getTagIdAndNameMap(List<Long> ids, Integer type);

    /**
     * 业务展示
     * @param relationType
     * @return
     */
    List<TagGroupCategoryDTO> getSubTags(Integer relationType);

    Long getInnvoteTagId();

    /**
     * 根据活动Id查询标签
     * @return
     */
    List<Long> getTagsByAct(Long actId, ActTagGroupEnum groupType);

    Map<Long, List<Long>> getTagsByActs(List<Long> actIds, ActTagGroupEnum groupType);

    Map<Long, List<String>> getTagNamesByActs(List<Long> actIds, ActTagGroupEnum groupType);

    List<Long> getSubIdsByTags(List<Long> tagIds, TagRelationTypeEnum relationTypeEnum);

    List<Long> getSubIdsByTagIdsAndCategoryId(List<Long> tagIds, Long categoryId);

    List<Long> getSubIdsByTagsTakeIntersection(List<Long> tagIds, TagRelationTypeEnum relationTypeEnum);

    /**
     * @Description  根据subId查询对应tag详情集合
     * @Date 19:33 2020-09-09
     * @Param [subId, subType]
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.tag.TuiaTagDTO>
     **/
    List<TuiaTagDTO> getTagBySubId(Long subId,Integer subType);


    List<TuiaTagDTO> getTagByIds(List<Long> tagIds);

    /**
     * 根据标签关联对象ID进行删除
     * @param subId
     * @param relationTypeEnum
     */
    void deleteBySubId(Long subId,TagRelationTypeEnum relationTypeEnum) throws ActivityCenterException;

    List<TagRelationDTO> getTagRelationBySubIds(List<Long> ids, Integer type);

    TuiaTagDTO getById(Long id);

    List<TuiaTagDTO> getByIds(List<Long> ids);

    /**
     * 根据大类ID、组别ID和标签ID查询业务ID
     */
    List<TagRelationDTO> listByAllIds(List<TagRelationDTO> relationList);

    /**
     * @Description  捞取所有广告位屏蔽词列表
     * @Param []
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.tag.TagRelationDTO>
     **/
    PageDto<TuiaTagDTO> getSlotKeyWords(ReqPageQuery req);

    /**
     * 捞取所有广告位屏蔽词列表 (带媒体信息)
     * @param req
     * @return
     */
    PageDto<SlotKeyTagDTO> getSlotKeyWordsMore(ReqPageQuery req);


    PageDto<OCRSlotKeyDTO> getOCRIndustrySlotKeyWordsMore(ReqPageQuery req);

    /**
     * @Description  获取总条数
     * @Date 10:41 2020-09-16
     * @Param []
     * @return java.lang.Integer
     **/
    Integer getSlotKeyWordsCount();

    Integer getOCRIndustrySlotKeyWordsCount();


    /**
     * 删除标签与业务关联
     */
    Boolean removeTagRelationByIds(List<Long> ids);

    /**
     * 批量新增标签与业务关联
     */
    Boolean saveBatchTagRelation(List<TagRelationDTO> relationList);

    /**
     * 更新标签与业务关联
     */
    Boolean updateTagRelationById(TagRelationDTO relation);

    List<TuiaTagDTO> getByGroupId(Long id);

    List<TuiaTagDTO> getByGroupIds(List<Long> ids);

    List<TagGroupDTO> getTagGroupByIds(List<Long> ids);

    /**
     * 根据业务ID和标签类型查询标签关联关系
     */
    List<TagRelationDTO> listTagRelation(List<Long> ids, Integer relationType);

    /**
     * 根据条件查询标签关联关系
     */
    List<TagRelationDTO> listTagRelationByParam(TagRelationDTO relationDTO);

    /**
     * 根据标签类型得到对应类别ID
     */
    Long getCategoryIdByRelationType(Integer relationType);

    /**
     * 根据业务ID和标签类型删除对应记录
     */
    int removeBySubIdAndRelationType(Long subId, Integer relationType);

    List<TagRelationDTO> getListTagRelationByType(List<TagRelationDTO> relationList);

    List<TagRelationDTO> getRelationList(TagRelationDTO dto);
}
