/**
 * Project Name:activity-center-api<br>
 * File Name:DataDto.java<br>
 * Package Name:cn.com.duiba.tuia.adx.center.api.common<br>
 * Date:2017年3月29日下午4:22:52<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.adx.center.api.common;

import java.math.BigDecimal;

/**
 * ClassName: DataDto <br/>
 * Function: 数据dto基类. <br/>
 * Reason: 重复代码懒得写. <br/>
 * date: 2017年3月29日 下午4:22:52 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class DataDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /** accessPv:曝光pv. */
    private Long              accessPv;

    /** accessUv:曝光uv. */
    private Long              accessUv;

    /** clickPv:点击pv总和. */
    private Long              clickPv;

    /** clickUv:点击uv总和. */
    private Long              clickUv;

    /** clickRate:点击率 点击pv/爆光pv. */
    private Float              clickRate;

    /** launchAmount:发券量. */
    private Long launchAmount;

    /**couponClickAmount:直接券点击*/
    private Long couponClickAmount;

    /**couponExposureAmount:直接券曝光*/
    private Long couponExposureAmount;

    /**  券曝光pv */
    private Long couponAccessPv;

    /** 券点击pv */
    private Long couponClickPv;

    /** couponClickRate:券点击率 券点击pv/券爆光pv. */
    private Float couponClickRate;

    public Long getLaunchAmount() {
        return launchAmount;
    }

    public void setLaunchAmount(Long launchAmount) {
        this.launchAmount = launchAmount;
    }

    public Long getCouponAccessPv() {
        return couponAccessPv;
    }

    public void setCouponAccessPv(Long couponAccessPv) {
        this.couponAccessPv = couponAccessPv;
    }

    public Long getCouponClickPv() {
        return couponClickPv;
    }

    public void setCouponClickPv(Long couponClickPv) {
        this.couponClickPv = couponClickPv;
    }

    public Float getCouponClickRate() {
        return couponClickRate;
    }

    public void setCouponClickRate(Float couponClickRate) {
        this.couponClickRate = couponClickRate;
    }

    public Float getClickRate() {
        return clickRate;
    }

    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    public Long getAccessPv() {
        return accessPv;
    }

    public void setAccessPv(Long accessPv) {
        this.accessPv = accessPv;
    }

    public Long getAccessUv() {
        return accessUv;
    }

    public void setAccessUv(Long accessUv) {
        this.accessUv = accessUv;
    }

    public Long getClickPv() {
        return clickPv;
    }

    public void setClickPv(Long clickPv) {
        this.clickPv = clickPv;
    }

    public Long getClickUv() {
        return clickUv;
    }

    public void setClickUv(Long clickUv) {
        this.clickUv = clickUv;
    }

    public Long getCouponClickAmount() {
        return couponClickAmount;
    }

    public void setCouponClickAmount(Long couponClickAmount) {
        this.couponClickAmount = couponClickAmount;
    }

    public Long getCouponExposureAmount() {
        return couponExposureAmount;
    }

    public void setCouponExposureAmount(Long couponExposureAmount) {
        this.couponExposureAmount = couponExposureAmount;
    }

    /**
         * @Description: calculateClickRate 计算点击率
         *
         * @Param: [divisor, dividend] 分子 分母
         * @Return: java.lang.Float
         * @throws:
         * @author: youhaijun
         * @Date:   2017/6/14
         */
    public static Float calculateClickRate(Long divisor, Long dividend) {
        Float result = null;
        if (dividend != null && divisor != null&& divisor.longValue() != 0 && dividend.longValue() != 0) {
            BigDecimal bigDivisor = new BigDecimal(divisor * 100);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 2, BigDecimal.ROUND_HALF_UP).floatValue();
        }
        return result;
    }

}
