/**
 * Project Name:activity-center-api<br>
 * File Name:SourceType.java<br>
 * Package Name:cn.com.duiba.tuia.adx.center.api.constant<br>
 * Date:2017年3月17日上午11:15:08<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.adx.center.api.constant;

/**
 * ClassName: SourceType <br/>
 * 引导页面类型的枚举 date: 2017年3月17日 上午11:15:08 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.6
 */
public enum PageType {

    ACTIVITY(0, "活动","activity"),

    MAINMEET(1, "主会场","mainMeet"),

    ACTCENTER(2, "活动中心","actCenter"),

    DIRECT(3,"直投页","directPage"),

    URL(4,"URL","URL"),

    GAME(5,"游戏","game"),

    ADVERT(6,"广告","advert"),

    PLUGIN(7,"插件", "plugin"),

    LANDING_PAGE(8, "落地页", "landingPage"),

    RETURN_AGLO(9, "返回拦截算法", "returnAglo");

    /** The code. */
    private Integer code;

    /** The desc. */
    private String  desc;
    
    private String key;

    /**
     * The Constructor.
     *
     * @param code the code
     * @param desc the desc
     */
    PageType(Integer code, String desc,String key) {
        this.code = code;
        this.desc = desc;
        this.key = key;
    }

    /**
     * Gets the code.
     *
     * @return the code
     */
    public Integer getCode() {
        return code;
    }

    /**
     * Gets the desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }
    
    public String getKey() {
        return key;
    }

    /**
     * 判断返回类型相等.
     *
     * @param code the code
     * @return true, if equals code
     */
    public boolean equalsCode(Integer code) {
        return this.code == code;
    }

}
