package cn.com.duiba.tuia.adx.center.api.constant;

import java.util.ArrayList;
import java.util.List;

public enum PluginDirectType {

    APP(1, "媒体"),
    SLOT(2,  "广告位"),
    ACTIVITY(3,  "活动");

    private Integer type;
    /** desc:描述. */
    private String  desc;

    PluginDirectType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static PluginDirectType getByType(int type) {
        for (PluginDirectType pluginType : PluginDirectType.values()) {
            if (pluginType.getType().equals(type)) {
                return pluginType;
            }
        }
        return null;
    }

    public static List<Integer> getDirectTypes(){
        List<Integer> types = new ArrayList<>();
        types.add(APP.type);
        types.add(SLOT.type);
        return types;
    }
    
}
