package cn.com.duiba.tuia.adx.center.api.constant;

/**
 * 场景枚举
 *
 * 作用：用于表示一些业务场景
 * 支持多级场景
 * sid使用2位小数，最大可配置100个
 * sid使用位数必须保持一致
 *
 * 自我感觉这个枚举很吊,
 *
 */
public enum Scene {


    ACTIVITY(null, "01", "活动"),

    PLUGIN(null, "02", "插件"),
        COMMON(PLUGIN, "01", "普通插件"),
        EMBEDDED(PLUGIN, "02", "嵌入式插件"),
        RESPONSIVE(PLUGIN, "03", "相应式插件"),
        TIMINGPLUGIN(PLUGIN, "04", "定时插件"),

    GUIDE(null, "03", "引导页"),

    RETURN(null, "04", "返回拦截"),
    ;

    Scene(Scene parent, String sid, String desc) {
        this.parent = parent;
        this.sid = sid;
        this.desc = desc;
    }

    /**
     * 父场景
     */
    private Scene parent;
    /**
     * 场景id
     */
    private String sid;
    /**
     * 描述
     */
    private String desc;
    /**
     * 总场景id
     */
    private String sceneId;

    public Scene getParent() {
        return parent;
    }

    public String getSid() {
        return sid;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 递归
     * @return
     */
    public String getSceneId() {
        if (sceneId == null) {
            sceneId = append(this, "");
        }
        return sceneId;
    }

    /**
     * 是否相同场景
     * @param scene
     * @return
     */
    public boolean equalsScene(Scene scene) {
        return this.getSceneId().equals(scene.getSceneId());
    }

    /**
     * 是否相同场景
     * @param sceneId
     * @return
     */
    public boolean equalsScene(String sceneId) {
        return this.getSceneId().equals(sceneId);
    }

    /**
     * 是否同属于一个场景
     * @param scene
     * @return
     */
    public boolean equalsParentScene(Scene scene) {
        if (this.getParent() == null || scene.getParent() == null) {
            return this.equals(scene);
        } else {
            return this.getParent().equalsScene(scene.getParent());
        }
    }

    private String append(Scene scene,String sid) {
        if (scene.getParent() == null) {
            return scene.getSid() + sid;
        }
        return append(scene.getParent(), scene.getSid());
    }

}
