package cn.com.duiba.tuia.adx.center.api.constant.adx;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 小米设备类型
 *
 * @Author chensong
 * @Create 2019-03-28
 */
public enum XiaoMiUserClientType {

    UNKNOW(0, "未知", UserClientType.UNKNOW),

    IPOHONE(1,"iPhone", UserClientType.PHONE),

    ANDROID(2,"Android手机", UserClientType.PHONE),

    IPAD(3,"iPad", UserClientType.MOV),

    WINDOWS_PHONE(4,"Windows手机", UserClientType.PHONE),

    ANDROID_PAD(5,"Android平板", UserClientType.MOV),

    SMART_TV(6,"智能TV", UserClientType.TV)
    ;

    private int type;

    private String desc;

    private UserClientType commonType;

    private XiaoMiUserClientType(int type, String desc, UserClientType commonType) {
        this.type = type;
        this.desc = desc;
        this.commonType = commonType;
    }

    public String getDesc() {
        return desc;
    }

    public int getType() {
        return type;
    }

    public UserClientType getCommonType() {
        return commonType;
    }

    public static XiaoMiUserClientType getByType(Integer type) {
        return Objects.isNull(type)
                ? UNKNOW
                : Stream.of(XiaoMiUserClientType.values())
                        .filter(item -> Objects.equals(item.getType(), type))
                        .findFirst().orElse(UNKNOW);
    }




}
