package cn.com.duiba.tuia.adx.center.api.constant.commercial.mission;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * [商业化活动]任务条件类型枚举
 *
 * @author zhangbaiqiang
 * @date 2019/03/07
 */
public enum MissionConditionType {

    LOGIN(1, "LOGIN", "登录", 0, "天", Arrays.asList(0, 1)),
    PLANT(2, "PLANT", "种红包", 1, "次", Arrays.asList(0, 1)),
    PICK(3, "PICK", "收红包", 1, "次", Arrays.asList(0, 1)),
    CONTINUOUS_LOGIN(4, "CONTINUOUS_LOGIN", "连续登录", 0, "天", Arrays.asList(2)),
    DIG(5, "DIG", "挖矿", 2, "次", Arrays.asList(0, 1)),
    ENTER_MINE_CAVE(6, "ENTER_MINE_CAVE", "进入矿洞", 2, "层", Arrays.asList(2)),
    OPEN_TREASURE_BOX(7, "OPEN_TREASURE_BOX", "开启宝箱", 2, "个", Arrays.asList(0, 1)),
    RETURN_LANDING_PAGE(8, "RETURN_LANDING_PAGE", "直接返回落地页连接", -1, "", Collections.emptyList()),
    HEAVENLY_TREASURE_CHEST(12, "HEAVENLY_TREASURE_CHEST", "天降宝箱", -1, "", Collections.emptyList()),
    VAT_RED_RAIN(13, "VAT_RED_RAIN", "红包雨", -1, "", Collections.emptyList()),
    VAT_TREASURE_CHEST(14, "VAT_TREASURE_CHEST", "增值任务宝箱", -1, "", Collections.emptyList()),
    WATER(15, "WATER", "浇水", -1, "", Collections.emptyList()),
    LOTTERY(16, "LOTTERY", "参与抽奖", -1, "", Collections.emptyList()),
    TREE_EXP(17, "TREE_EXP", "成长值达到", -1, "", Collections.emptyList()),
    ENCOURAGE_VIDEO(18, "ENCOURAGE_VIDEO", "激励视频", 0, "", Arrays.asList(0,1,2)),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 键名
     */
    private String key;

    /**
     * 描述
     */
    private String desc;

    /**
     * 活动类型（-1 特殊（无法通过在后台通过任务条件配置的那种）  0.通用; 1.种红包; 2.挖矿）
     */
    private Integer bizActivityType;

    /**
     * 数量单位
     */
    private String amountUnit;

    /**
     * 适用的任务循环类型
     */
    private List<Integer> missionCycleTypes;

    MissionConditionType(Integer type, String key, String desc, Integer bizActivityType,
                         String amountUnit, List<Integer> missionCycleTypes) {
        this.type = type;
        this.key = key;
        this.desc = desc;
        this.bizActivityType = bizActivityType;
        this.amountUnit = amountUnit;
        this.missionCycleTypes = missionCycleTypes;
    }

    public Integer getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getBizActivityType() {
        return bizActivityType;
    }

    public String getAmountUnit() {
        return amountUnit;
    }

    public List<Integer> getMissionCycleTypes() {
        return missionCycleTypes;
    }

    /**
     * 获取任务的枚举
     *
     * @param key 任务类型键名
     * @return 枚举
     */
    public static MissionConditionType getByKey(String key) {
        for (MissionConditionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 获取任务的类型
     *
     * @param key 任务条件键名
     * @return 任务条件类型
     */
    public static Integer getTypeByKey(String key) {
        for (MissionConditionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum.getType();
            }
        }
        return null;
    }

    /**
     * 获取任务的类型
     *
     * @param type 任务条件类型
     * @return 任务条件键名
     */
    public static String getKeyByType(Integer type) {
        for (MissionConditionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getKey();
            }
        }
        return null;
    }

    public static boolean isTypeExist(Integer type) {
        for (MissionConditionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return true;
            }
        }
        return false;
    }
}
