/**
 * Project Name:activity-center-api<br>
 * File Name:PrizeDto.java<br>
 * Package Name:cn.com.duiba.tuia.adx.center.api.dto<br>
 * Date:2017年6月1日上午10:46:51<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.adx.center.api.dto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.adx.center.api.dto.req.RedPacket;
import cn.com.duiba.tuia.adx.center.api.common.BaseDto;
import cn.com.duiba.tuia.adx.center.api.constant.AlipayType;
import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * ClassName: PrizeDto <br/>
 * Function: 奖项Dto. <br/>
 * Reason: . <br/>
 * date: 2017年6月1日 上午10:46:51 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.8
 */
public class PrizeDto extends BaseDto {

    private static final long serialVersionUID = 1L;
    public static final String DEFAULPRIZERECOMMENDCONTENT = "正在火速处理中，查看进度请点击";
    private Long              id;

    /** title:奖品标题. */
    private String            title;

    /** prizeType:奖项类型. */
    private String            prizeType;

    /** listImage:列表图片. */
    private String            listImage;

    /** bannerImage:banner图. */
    private String            bannerImage;

    /** detailImage:详情图. */
    private String            detailImage;

    /** description:.说明 */
    private String            description;

    /** detailDesc:详细说明. */
    private String            detailDesc;

    /** stockId:库存id. */
    private Long              stockId;

    /** stock:库存值（管理端查询时用）. */
    private Long           stock;

    /** totalStock:总库存(管理端查询时用) */
    private Long           totalStock;

    /** stockChange:库存变化值（管理端保存时用）. */
    private Long           stockChange;

    /** visionPlanner:视觉. */
    private String            visionPlanner;

    /** isOpen:是否开启. */
    private Boolean           isOpen;

    /** isDeleted:是否删除. */
    private Boolean           isDeleted;

    /**中奖弹层文案**/
    private String prizeRecommendContent;

    /** 以json string格式保存的扩展信息*/
    private String extInfo;

    /** 奖品价值，以json格式保存在extInfo中*/
    private Integer prizeValue;

    /** virtualType:虚拟商品类型. */
    private Integer          virtualType;
    
    /** virtualType:虚拟商品子类型. */
    private Integer          subType;

    /** 批次id*/
    private String           batchId;

    /**api充值*/
    private ApiRechargeDto apiRechargeDto;

    /**
     * 跳转快应用信息
     * 快应用包名(必填)  跳转路径(非必填)
     */
    private QuickApplicationRechargeDto quickApplicationRechargeDto;
    /**
     * 跳转H5链接
     * 跳转的H5路径(必填)
     */
    private H5RechargeDto h5RechargeDto;

    /**账号收集*/
    private List<AccountRechargeDto> accountRechargeDto;

    /**劵码*/
    private CouponsCodeDto couponsCodeDto;
    
    /** accountSwitch:账号开关(0:关 1：开). */
    private Integer accountSwitch;

    private List<CouponsCodeBatchInfoDto> couponsCodeBatchInfoDtos;

    private List<String> stockIds;

    /** 是否是老数据 0老 1新*/
    private Integer isOld;

    /** 瓜分红包*/
    private RedPacket redPacket;

    /** 奖品描述 */
    private String prizeDesc;
    /** 是否已打标签，true：是，false：否 */
    private Boolean hasTag;
    /** 是否添加奖品描述，true：是，false：否 */
    private Boolean hasDesc;
    /** 奖品标签列表 */
    private List<Long> tags;

    /** 是否已打组件化标签，true：是，false：否 */
    private Boolean hasSubTag;
    /** 组件标签列表 */
    private List<Long> subTags;
    /** 组件标签列表 */
    private List<String> subTagStrs;
    /** 算法投放次数 */
    private Long algoCount;

    public QuickApplicationRechargeDto getQuickApplicationRechargeDto() {
        return quickApplicationRechargeDto;
    }

    public void setQuickApplicationRechargeDto(QuickApplicationRechargeDto quickApplicationRechargeDto) {
        this.quickApplicationRechargeDto = quickApplicationRechargeDto;
    }

    public H5RechargeDto getH5RechargeDto() {
        return h5RechargeDto;
    }

    public void setH5RechargeDto(H5RechargeDto h5RechargeDto) {
        this.h5RechargeDto = h5RechargeDto;
    }

    public PrizeDto() {
        super();
    }
    
    public PrizeDto(Long id, Long stockChange) {
        super();
        this.id = id;
        this.stockChange = stockChange;
    }
    
    
    public PrizeDto(Long id, Boolean isOpen) {
        super();
        this.id = id;
        this.isOpen = isOpen;
    }
    
    public Integer getPrizeValue() {
        return prizeValue;
    }

    public void setPrizeValue(Integer prizeValue) {
        this.prizeValue = prizeValue;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public String getListImage() {
        return listImage;
    }

    public void setListImage(String listImage) {
        this.listImage = listImage;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getDetailImage() {
        return detailImage;
    }

    public void setDetailImage(String detailImage) {
        this.detailImage = detailImage;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetailDesc() {
        return detailDesc;
    }

    public void setDetailDesc(String detailDesc) {
        this.detailDesc = detailDesc;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public Long getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Long totalStock) {
        this.totalStock = totalStock;
    }

    public Long getStockChange() {
        return stockChange;
    }

    public void setStockChange(Long stockChange) {
        this.stockChange = stockChange;
    }

    public String getVisionPlanner() {
        return visionPlanner;
    }

    public void setVisionPlanner(String visionPlanner) {
        this.visionPlanner = visionPlanner;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Boolean getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }


    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }


    public void setValueByExtInfo() {
        if(StringUtils.isNotBlank(this.getExtInfo())) {
            JSONObject jsonObject = JSONObject.parseObject(this.getExtInfo());
            this.setPrizeValue(jsonObject.getIntValue("prizeValue"));
            JSONArray jsonArray = jsonObject.getJSONArray("stockIds");
            if(jsonArray!=null) {
                this.setStockIds(jsonArray.toJavaList(String.class));
            }
        }
    }

    public void setExtInfoByValue(){
        Map<String,Object> map = new HashMap<>(1);
        map.put("prizeValue",this.getPrizeValue());
        map.put("stockIds",this.getStockIds());
        this.setExtInfo(JSON.toJSONString(map));
    }
    
    public ApiRechargeDto getApiRechargeDto() {
        return apiRechargeDto;
    }

    
    public void setApiRechargeDto(ApiRechargeDto apiRechargeDto) {
        this.apiRechargeDto = apiRechargeDto;
    }

    
    
    public CouponsCodeDto getCouponsCodeDto() {
        return couponsCodeDto;
    }

    
    public void setCouponsCodeDto(CouponsCodeDto couponsCodeDto) {
        this.couponsCodeDto = couponsCodeDto;
    }
    
    public Integer getAccountSwitch() {
        return accountSwitch;
    }
    
    public void setAccountSwitch(Integer accountSwitch) {
        this.accountSwitch = accountSwitch;
    }
    
    public List<AccountRechargeDto> getAccountRechargeDto() {
        return accountRechargeDto;
    }
    
    public void setAccountRechargeDto(List<AccountRechargeDto> accountRechargeDto) {
        this.accountRechargeDto = accountRechargeDto;
    }
    
    public Integer getVirtualType() {
        return virtualType;
    }

    
    public void setVirtualType(Integer virtualType) {
        this.virtualType = virtualType;
    }

    
    public Integer getSubType() {
        return subType;
    }

    
    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getPrizeRecommendContent() {
        return prizeRecommendContent;
    }

    public void setPrizeRecommendContent(String prizeRecommendContent) {
        this.prizeRecommendContent = prizeRecommendContent;
    }

    /**
     * 
     * setExtInfoToObj:(转换成对象). <br/>
     *
     * @author guyan
     * @since JDK 1.6
     */
    public void setExtInfoToObj(VirtualGoodsInfoDto goods){
        if (goods==null) {
            return;
        }
        String extInfo = goods.getExtInfo();
        Integer virtualType = goods.getVirtualType();
        if(StringUtils.isNotBlank(extInfo) && virtualType!=null) {
            JSONObject jsonObject = JSONObject.parseObject(extInfo);
            if (AlipayType.VIRTUAL_API.getType().equals(virtualType)) {
                this.setAccountSwitch(jsonObject.getInteger("accountSwitch"));
                this.setApiRechargeDto(jsonObject.getObject("apiRecharge",ApiRechargeDto.class));
                JSONArray array=jsonObject.getJSONArray("accountInfo");
                List<AccountRechargeDto> list = paramAccountJson(array);
                this.setAccountRechargeDto(list); 
            }else if (AlipayType.VIRTUAL_TICKET.getType().equals(virtualType)) {
                this.setCouponsCodeDto(jsonObject.getObject("coupons",CouponsCodeDto.class));
            }else if (AlipayType.VIRTUAL_ACCOUNT.getType().equals(virtualType)) {
                this.setAccountSwitch(jsonObject.getInteger("accountSwitch"));
                JSONArray array=jsonObject.getJSONArray("accountInfo");
                List<AccountRechargeDto> list = paramAccountJson(array);
                this.setAccountRechargeDto(list);
            } else if (AlipayType.VIRTUAL_RED_PACKET.getType().equals(virtualType)) {
                this.setRedPacket(jsonObject.getObject("redPacket",RedPacket.class));
            }else if(AlipayType.JUMP_QUICK_APPLICATION.getType().equals(virtualType)){
                this.setQuickApplicationRechargeDto(jsonObject.getObject("quickApplicationRecharge", QuickApplicationRechargeDto.class));
            }else if(AlipayType.JUMP_H5.getType().equals(virtualType)){
                this.setH5RechargeDto(jsonObject.getObject("h5Recharge", H5RechargeDto.class));
            }
        } 
    }
    
    public static ApiRechargeDto getApiRechargeDto(String extInfo){
    	JSONObject jsonObject = JSONObject.parseObject(extInfo);
    	return jsonObject.getObject("apiRecharge",ApiRechargeDto.class);
    }
   
    private List<AccountRechargeDto> paramAccountJson(JSONArray array) {
        List<AccountRechargeDto> list=new ArrayList<>();
        if (BaseDto.isNotEmpty(array)) {
            for (Object object : array) {
                JSONObject obj = (JSONObject) object;
                AccountRechargeDto dto = JSONObject.toJavaObject(obj,AccountRechargeDto.class);
                list.add(dto);
            } 
        }
        return list;
    }
    
    public static CouponsCodeDto getCouponsCodeDto(String extInfo){
        if (StringUtils.isNotBlank(extInfo)) {
            JSONObject jsonObject = JSONObject.parseObject(extInfo);
            return jsonObject.getObject("coupons",CouponsCodeDto.class);
        }
        return null;
    }


    public List<CouponsCodeBatchInfoDto> getCouponsCodeBatchInfoDtos() {
        return couponsCodeBatchInfoDtos;
    }

    public void setCouponsCodeBatchInfoDtos(List<CouponsCodeBatchInfoDto> couponsCodeBatchInfoDtos) {
        this.couponsCodeBatchInfoDtos = couponsCodeBatchInfoDtos;
    }

    public Integer getIsOld() {
        return isOld;
    }

    public void setIsOld(Integer isOld) {
        this.isOld = isOld;
    }

    public List<String> getStockIds() {
        return stockIds;
    }

    public void setStockIds(List<String> stockIds) {
        this.stockIds = stockIds;
    }

    public RedPacket getRedPacket() {
        return redPacket;
    }

    public void setRedPacket(RedPacket redPacket) {
        this.redPacket = redPacket;
    }

    public String getPrizeDesc() {
        return prizeDesc;
    }

    public void setPrizeDesc(String prizeDesc) {
        this.prizeDesc = prizeDesc;
    }

    public Boolean getHasTag() {
        return hasTag;
    }

    public void setHasTag(Boolean hasTag) {
        this.hasTag = hasTag;
    }

    public Boolean getHasDesc() {
        return hasDesc;
    }

    public void setHasDesc(Boolean hasDesc) {
        this.hasDesc = hasDesc;
    }

    public List<Long> getTags() {
        return tags;
    }

    public void setTags(List<Long> tags) {
        this.tags = tags;
    }

    public Boolean getHasSubTag() {
        return hasSubTag;
    }

    public void setHasSubTag(Boolean hasSubTag) {
        this.hasSubTag = hasSubTag;
    }

    public List<Long> getSubTags() {
        return subTags;
    }

    public void setSubTags(List<Long> subTags) {
        this.subTags = subTags;
    }

    public List<String> getSubTagStrs() {
        return subTagStrs;
    }

    public void setSubTagStrs(List<String> subTagStrs) {
        this.subTagStrs = subTagStrs;
    }

    public Long getAlgoCount() {
        return algoCount;
    }

    public void setAlgoCount(Long algoCount) {
        this.algoCount = algoCount;
    }
}
