package cn.com.duiba.tuia.adx.center.api.dto.adx;

import cn.com.duiba.tuia.adx.center.api.constant.adx.AdxTypeEnum;

import java.io.Serializable;
import java.util.List;

/**
 * 资源位媒体对应的广告位类型
 * <p>注意，该对象只对仅有广告位类型的资源有用，
 * 目前适合的adx参考{@link AdxTypeEnum}中storeType=2</p>
 *
 * @author lixin
 * @date 2019/8/15 10:04
 **/
public class SlotStyleDto implements Serializable {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 1681903465613252436L;

    /**
     * 广告位类型编码
     */
    private String specCode;

    /**
     * 广告位类型描述
     */
    private String specDesc;

    /**
     * 标题的限制字数
     */
    private Integer titleLimit;
//
//    /**
//     * 描述的限制字数
//     */
//    private Integer contentLimit;

    /**
     * 该广告位下的规格列表
     */
    private List<StyleDetail> detailList;

    public String getSpecCode() {
        return specCode;
    }

    public void setSpecCode(String specCode) {
        this.specCode = specCode;
    }

    public String getSpecDesc() {
        return specDesc;
    }

    public void setSpecDesc(String specDesc) {
        this.specDesc = specDesc;
    }

    public List<StyleDetail> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<StyleDetail> detailList) {
        this.detailList = detailList;
    }

    public Integer getTitleLimit() {
        return titleLimit;
    }

    public void setTitleLimit(Integer titleLimit) {
        this.titleLimit = titleLimit;
    }

//    public Integer getContentLimit() {
//        return contentLimit;
//    }
//
//    public void setContentLimit(Integer contentLimit) {
//        this.contentLimit = contentLimit;
//    }

    /**
     * 广告位类型详情
     */
    public static class StyleDetail implements Serializable {

        /**
         * serialVersionUID
         */
        private static final long serialVersionUID = -7619888740802442691L;

        /**
         * 样式规格
         */
        private Integer styleStandard;

        /**
         * 样式名称
         */
        private String styleDesc;

        /**
         * 素材宽度
         */
        private Integer picW;

        /**
         * 素材高度
         */
        private Integer picH;

        /**
         * 素材个数
         */
        private Integer picNum;

        /**
         * 素材大小
         */
        private Integer size;

        /**
         * 素材格式
         */
        private String pictureType;

        /**
         * 素材时长
         */
        private String duration;

        /**
         * 标题的限制字数
         */
        private Integer contentLimit;

        /**
         * 描述的限制字数
         */
        private Integer titleLimit;

        /**
         * 备用字段，用于处理同一个规格下多种图片的情况（比如OPPO的竖屏开屏）
         */
        private List<StyleDetail> batchDetail;

        /**
         * 广告样式
         */
        private String template;

        public String getDuration() {
            return duration;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public Integer getStyleStandard() {
            return styleStandard;
        }

        public void setStyleStandard(Integer styleStandard) {
            this.styleStandard = styleStandard;
        }

        public String getStyleDesc() {
            return styleDesc;
        }

        public void setStyleDesc(String styleDesc) {
            this.styleDesc = styleDesc;
        }

        public Integer getPicW() {
            return picW;
        }

        public void setPicW(Integer picW) {
            this.picW = picW;
        }

        public Integer getPicH() {
            return picH;
        }

        public void setPicH(Integer picH) {
            this.picH = picH;
        }

        public Integer getSize() {
            return size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public String getPictureType() {
            return pictureType;
        }

        public void setPictureType(String pictureType) {
            this.pictureType = pictureType;
        }

        public Integer getContentLimit() {
            return contentLimit;
        }

        public void setContentLimit(Integer contentLimit) {
            this.contentLimit = contentLimit;
        }

        public Integer getTitleLimit() {
            return titleLimit;
        }

        public void setTitleLimit(Integer titleLimit) {
            this.titleLimit = titleLimit;
        }

        public List<StyleDetail> getBatchDetail() {
            return batchDetail;
        }

        public void setBatchDetail(List<StyleDetail> batchDetail) {
            this.batchDetail = batchDetail;
        }

        public Integer getPicNum() {
            return picNum;
        }

        public void setPicNum(Integer picNum) {
            this.picNum = picNum;
        }

        public String getTemplate() {
            return template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }
    }
}
