package cn.com.duiba.tuia.adx.center.api.dto.adx.audit;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 视频审核
 *
 * @author peanut.huang
 * @date 2020/2/10 11:18
 */
@Data
public class AdxAuditVideoDto implements Serializable {

    private static final long serialVersionUID = 960104829450480421L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 视频广告 Url
     */
    private String videoUrl;

    /**
     * 视频大小 ( 单位 :: Byte )
     */
    private Integer videoSize;

    /**
     * 视频单位 ( 单位 :: Byte )
     */
    private String unit;

    /**
     * 视频时长 ( 单位 :: Secend/秒 )
     */
    private BigDecimal duration;

    /**
     * 视频分辨率水平显示每英寸点（ dpi ）的数量
     * 如: ( x ) 1280 x ( y ) 720
     */
    private Integer resolutionX;

    /**
     * 视频分辨率垂直显示每英寸点（ dpi ）的数量
     * 如: ( x ) 1280 x ( y ) 720
     */
    private Integer resolutionY;

    /**
     * 视频封面图片 Url
     */
    private String coverUrl;

    /**
     * 视频封面图片宽度
     */
    private Integer coverWidth;

    /**
     * 视频封面图片高度
     */
    private Integer coverHeight;
}
