package cn.com.duiba.tuia.adx.center.api.dto.algo;

import cn.com.duiba.tuia.adx.center.api.constant.algo.AlgoStatusEnum;
import cn.com.duiba.tuia.adx.center.api.constant.algo.TestFlowTypeEnum;
import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class AlgoTestPlanDTO extends BaseDto {

    /**
     *  测试计划名
     */
    private String testPlanName;

    /**
     *  测试计划类型 {@link TestFlowTypeEnum}
     */
    private Integer testFlowType;


    /**
     *  测试计划状态 {@link AlgoStatusEnum}
     */
    private Integer testPlanStatus;

    /**
     *  操作人
     */
    private String operatorName;

    /**
     *  测试计划开始时间
     */
    private Date startTime;

    /**
     *  测试计划结束时间
     */
    private Date endTime;

    /**
     *  流量占比
     */
    private Integer flowRatio;

    private String slotIds;


    /**
     *  测试组
     */
    private List<AlgoTestGroupDTO> testGroupList;


    /**
     *  测试广告位
     */
    private List<AlgoTestSlotDTO> testSlotList;
}
