/**
 * Copyright (c) 2020, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.adx.center.api.dto.dpa;

import lombok.Data;

import java.io.Serializable;

/**
 * 描述: 活动算法特征
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2020/7/30 14:57
 */
@Data
public class ActivityAlgoFeatureDTO implements Serializable {
    private static final long serialVersionUID = 2001858075218207782L;

    /* 活动ID */
    private Long activityId;

    /* 自动首次出券状态 0-关 1-开 */
    private Integer autoFirstLaunchStatus;

    /* 增值状态 0-关 1-开 */
    private Integer encStatus;

    /* 广告定制弹层状态 0-关 1-开 */
    private Integer layerStatus;

    /* 活动预出券状态 0-关 1-开 */
    private ActPreLaunchDTO actPreLaunchDTO;

    /* 活动定制广告白名特征 */
    private PlanAdvertFeatureDTO planAdvertFeatureDTO;

    /* 区块状态 0-关 1-开 */
    private Integer blockStatus;


}
