package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.common.PageDto;
import cn.com.duiba.tuia.adx.center.api.dto.algo.*;

import java.util.List;

/**
 * 算法标题
 */
@AdvancedFeignClient
public interface RemoteActivityAlgoTitleService {

    /**
     * 算法标题 查询列表
     * @param req titleType=0时表示查询主副标题
     * @return
     */
    PageDto<ActivitySkinTitleDTO> getActivityTitleList(ActivitySkinTitleReqDTO req);

    /**
     * 算法标题 新增
     * @param req
     * @return
     */
    int saveActivityTitle(ActivitySkinTitleDTO req);

    /**
     * 查询裁剪次数少于X次的字符串
     * @param titleFontCutNum
     * @return
     */
    List<ActivitySkinTitleDTO> getActivityTitleAllList(Integer titleFontCutNum);
    int getActivityTitleAllListCount(Integer titleFontCutNum);

    /**
     * 算法标题 修改
     * @param req
     * @return
     */
    int updateActivityTitle(ActivitySkinTitleDTO req);

    int updateActivityTitleByContent(ActivitySkinTitleDTO req);

    /**
     * 算法标题 查询详情
     * @param id
     * @return
     */
    ActivitySkinTitleDTO getActivityTitleDetail(Long id);

    /**
     * 标题定向关系处理，查询返回列表，上游自己根据orientType分组，或orientId查询----------------
     */
    List<ActivitySkinTitleOrientDTO> getActivityTitleOrientList(ActivitySkinTitleOrientDTO req);

    /**
     * 标签关联关系修改
     */
    Boolean updateActivityTitleOrient(List<ActivitySkinTitleOrientDTO> reqList);

    /**
     * 标签关联关系查询，主副标签是两套的------------------------------------------------------
     */
    List<ActivityTitleFirstTagDTO> getActivityTitleTagList();

    /**
     * 标签关联关系修改
     */
    Boolean updateActivityTitleTag(ActivityTitleFirstTagDTO req);


    /**
     * 算法标题列表 查询
     * @param ids
     * @return
     */
    List<ActivitySkinTitleDTO> listActivityTitleDetail(List<Long> ids);

    /**
     * 根据皮肤类型和媒体行业标签id 获取定向的标题列表
     * 暂时不用的！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！ todo
     * @return
     */
    List<ActivityTitleAlgoOrientDTO> listOrientTitles(ActivityTitleListAlgoKeyDTO reqDTO);

    /**
     * 根据皮肤类型和媒体行业标签id 获取可用的标题列表
     * @return
     */
    List<ActivityTitleAlgoOrientDTO> listCanUseActivityTitles(ActivityTitleListAlgoKeyDTO reqDTO);

    /**
     * 字体裁剪，字符串列表 查询----------------------------
     * @param req
     * @return
     */
    List<ActivitySkinTitleCutDTO> getTitleCutList(ActivitySkinTitleCutDTO req);

    /**
     * 新增字体库时，需要裁剪的字符串，裁剪包，分组小于种类的字符串
     * @param req
     * @return
     */
    List<ActivityTitleNeedCutDTO> getTitleNeedCutList(ActivityTitleNeedCutDTO req);

    /**
     * 字符串 新增
     * @param req
     * @return
     */
    int saveTitleCut(ActivitySkinTitleCutDTO req);

    /**
     * 查询使用了指定标题的活动列表
     * @param titleId 指定标题id
     * @param titleType 标题类别，主1副2
     * @return
     */
    List<Long> listActivityUseConfirmTitle(Long titleId, Integer titleType);

    /**
     * 查询使用了指定标题的活动皮肤类别的列表
     * @param titleId
     * @param titleType
     * @return
     */
    List<ActivitySkinTitleOrientDTO> listActivitySkinTemplateByTitleId(Long titleId, Integer titleType);

    /**
     * 更新主标题的黑名单副标题ID列表
     * @param titleFirstId
     * @param titleSecondIds
     * @return
     */
    Boolean updateFirstTitleBlackSecondTitleIds(Long titleFirstId, List<Long> titleSecondIds);

    /**
     * 分页查询副标题，以及主标题的黑名单副标题ID列表
     * @param req
     * @return
     */
    PageDto<ActivitySkinTitleDTO> listFirstTitleBlackSecondTitleIds(ActivitySkinTitleReqDTO req);

    /**
     * 查询能配置主标题的活动id列表
     * @return
     */
    List<Long> listActivityIdByHasFirstTitleName();

    /**
     * 根据常规字体的字体类型删除字体库文件记录
     * @param fontType
     * @return
     */
    Boolean deleteFontByFontType(Integer fontType);

    /**
     * 算法标题 根据标题内容、排除的标题ID 查询列表(不管是否下线）
     * @param req
     * @return
     */
    List<ActivitySkinTitleDTO> listActivityTitleByTitleContent(ActivitySkinTitleReqDTO req);


    List<Long> titleTags(Long titleId);

}
