package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.ActivityOptionNoticeDto;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-10-22 14:24
 */
@AdvancedFeignClient
public interface RemoteActivityOptionNoticeService {

    /**
     * 添加提醒人
     * @param activityOptionNoticeDto
     */
    void insert(ActivityOptionNoticeDto activityOptionNoticeDto);

    /**
     * 修改提醒人
     * @param activityOptionNoticeDto
     */
    void update(ActivityOptionNoticeDto activityOptionNoticeDto);

    /**
     * 删除提醒人
     * @param activityOptionNoticeDto
     */
    void updateNull(ActivityOptionNoticeDto activityOptionNoticeDto);

    /**
     * 根据活动id 获取对应报警人
     * @param activityId
     * @return
     */
    ActivityOptionNoticeDto getByActivityId(Long activityId);

    /**
     * 修改缓存
     * @param type
     * @param adminId
     */
    void updateNoticeCache(String type, Long adminId, Long activityId, Integer status);

    /**
     * 获取不再提醒名单缓存
     * @param type
     * @return
     */
    String getNoticeNoPeople(String type,Long activityId);


}
