package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.common.PageDto;
import cn.com.duiba.tuia.adx.center.api.dto.layertest.AdvertLayerTestDto;
import cn.com.duiba.tuia.adx.center.api.dto.layertest.LayerTestDto;
import cn.com.duiba.tuia.adx.center.api.dto.req.AdvertLayerTestPageReq;

import java.util.List;

/**
 * 广告弹层测试配置服务
 *
 * @author weny.cai
 * @date 2018/11/1 16:13
 **/
@AdvancedFeignClient
public interface RemoteAdvertLayerTestService {

    Integer add(AdvertLayerTestDto dto) throws BizException;

    Integer update(AdvertLayerTestDto dto) throws BizException;

    void delete(Long advertId);

    void deleteById(List<Long> idList);

    PageDto<AdvertLayerTestDto> advertLayerTestPageQuery(AdvertLayerTestPageReq req);

    List<LayerTestDto> getLayerTestByAdvertId(Long advertId);

    List<LayerTestDto> getAllLayerTest();

}
