
package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.JmTagDto;
import cn.com.duiba.tuia.adx.center.api.dto.JmTagLevelDto;

import java.util.List;

/**
 * ClassName:RemoteJmTagService <br/>
 * Function: 积木标签标签remote. <br/>
 * Date: Date: 2020年6月19日 上午10:37:37 <br/>
 *
 * @author lijian
 * @see
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteJmTagService {

    /**
     * insertTag:(新增). <br/>
     *
     * @param dto
     * @return
     * @since JDK 1.8
     */
    Integer insertTag(JmTagDto dto);

    /**
     * 批量新增标签数据
     *
     * @param dto
     * @return
     */
    Integer updateTagById(JmTagDto dto);

    /**
     * getAllTags:(查询所有有效标签). <br/>
     *
     * @return
     * @since JDK 1.8
     */
    List<JmTagLevelDto> getAllTags();

    /**
     * 根据父标签id,查询子标签级别查询最大子级标签编码
     *
     * @param parentId 父标签ID
     * @return
     */
    String getMaxTagNum(Long parentId);

    /**
     * getTagByTagName:(根据父标签id,标签名,查询父级标签下标签是否重名). <br/>
     *
     * @param dto
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    JmTagDto getTagByTagName(JmTagDto dto);

}
