package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.plant.CheckDto;
import cn.com.duiba.tuia.adx.center.api.dto.plant.MaterialDto;
import cn.com.duiba.tuia.adx.center.api.dto.plant.PlantDto;
import cn.com.duiba.tuia.adx.center.api.dto.plant.PlantUserReq;
import cn.com.duiba.tuia.adx.center.api.dto.plant.configV2.mission.MissionConfigDto;
import cn.com.duiba.tuia.adx.center.api.dto.plant.configV2.prize.PlantV2ConfigDto;
import cn.com.duiba.tuia.adx.center.api.exception.ActivityCenterException;

/**
 * [种红包V2]Remote接口
 *
 * @author zhangbaiqiang
 * @date 2018/12/17
 */
@AdvancedFeignClient
public interface RemotePlantV2Service {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(PlantUserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param req 用户参数
     * @param landId 土地编号
     * @param seedType 种子类型
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(PlantUserReq req, Integer landId, Integer seedType) throws BizException;

    /**
     * 采摘红包
     *
     * @param req 用户参数
     * @param seedId 种子编号
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(PlantUserReq req, Long seedId) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param req 用户参数
     * @param missionId 任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishMission(PlantUserReq req, String missionId) throws BizException;

    /**
     * 提现
     *
     * @param req 用户参数
     * @return 种红包用户信息
     * @throws BizException
     */
    PlantDto withdraw(PlantUserReq req) throws BizException;

    /**
     * 判断是否能够提现
     *
     * @param req 用户参数
     * @return 校验结果
     */
    CheckDto canWithdraw(PlantUserReq req);

    /**
     * 更新奖励配置参数(慎用)
     *
     * @param appId 媒体id
     * @param configVersion 配置版本
     * @param configDto 奖励配置对象
     * @return 是否更新成功
     */
    boolean updatePlantPrizeConfig(Long appId, String configVersion, PlantV2ConfigDto configDto);

    /**
     * 更新任务配置参数(慎用)
     *
     * @param appId 媒体id
     * @param configVersion 配置版本
     * @param configDto 奖励配置对象
     * @return 是否更新成功
     */
    boolean updatePlantMissionConfig(Long appId, String configVersion, MissionConfigDto configDto);

    /**
     * 获取种红包任务配置
     *
     * @param appId 媒体id
     * @param configVersion 配置版本
     * @return 种红包任务配置
     */
    MissionConfigDto queryMissionConfig(Long appId, String configVersion) throws BizException;

    /**
     * 获取种红包奖励配置
     *
     * @param appId 媒体id
     * @param configVersion 配置版本
     * @return 种红包奖励配置
     */
    PlantV2ConfigDto queryPrizeConfig(Long appId, String configVersion) throws BizException;

    /**
     * 初始化现金库存
     *
     * @param appId 媒体
     * @param configVersion 配置版本
     * @param stock 初始库存库存
     * @return 当前库存
     */
    Integer initCashStock(Long appId, String configVersion, Integer stock);

    /**
     * [测试用接口]清除缓存
     *
     * @param deviceId 设备id
     * @param appId 媒体id
     * @param date 签到日期
     */
    Boolean resetForTest(String deviceId, Long appId, String date);



    MaterialDto selectByDeviceIdAndAppIdLast(PlantUserReq req) throws ActivityCenterException;
}
