package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.RedPacketNumsDto;
import cn.com.duiba.tuia.adx.center.api.dto.RedPacketPopusDto;

import java.util.List;

/**
 * 瓜分红包的相关服务
 *
 * @author lichao 2018/3/13
 */
@AdvancedFeignClient
public interface RemoteRedPacketPopusService {


    /**
     * 通过Consumer 进行查询人气
     *
     * @param appId      媒体id
     * @param consumerId 临时用户id
     * @param pageId     直投页id
     * @return 用户获得的人气
     */
    RedPacketPopusDto selectByConsumer(Long appId, Long consumerId, Long pageId);

    /**
     * 通过Consumer 进行查询人气
     *
     * @param appId      媒体id
     * @param consumerId 临时用户id
     * @return 用户获得的人气
     */
    List<RedPacketPopusDto> selectListByConsumer(Long appId, Long consumerId);

    /**
     * 将临时用户合并到登录用户身上
     * @param appId 媒体id
     * @param oldConsumerId 临时账户
     * @param newConsumerId 持久账户
     * @param insertValues 新增的账户
     */
    void mergeConsumer(Long appId, Long oldConsumerId, Long newConsumerId, List<RedPacketPopusDto> insertValues);

    /**
     * 增加用户人气
     *
     * @param appId      媒体id
     * @param pageId     直投页id
     * @param consumerId 临时用户id
     * @param popus      人气
     * @return 获得的人气数量
     */
    int addPopus2Consumer(Long appId, Long pageId, Long consumerId, String popus);

    /**
     * 修改
     *
     * @param redPacketPopusDto 需要修改的数据
     */
    void update(RedPacketPopusDto redPacketPopusDto);

    /**
     * 通过pageId获取所有数值
     *
     * @param pageId
     * @return
     */
    RedPacketNumsDto selectNumbers(Long pageId);

    /**
     * 持久化数值
     *
     * @param redPacketNumsDto
     */
    void insertNumbers(RedPacketNumsDto redPacketNumsDto);


}
