package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.NickNameDto;
import cn.com.duiba.tuia.adx.center.api.dto.consumer.ConsumerDto;

/**
 * Created by houwen on 26/07/2017.
 */
@AdvancedFeignClient
public interface RemoteTuiaUserService {


    /**·
     * 根据media_user_id或者phone来查询用户，查询不到就创建用户
     *  [注意]此接口只提供给金币业务，会创建可登录的用户，普通活动使用findByAppIdAndDeviceId接口
     * @param consumer
     * @return 包含用户密码的用户信息集合
     */
    ConsumerDto findOrCreateConsumer(ConsumerDto consumer);

    /***
         * @Description: findConsumer 根据media_user_id或者phone来查询正式用户用户
         * 数据源tuia_consumer
         * @Param: [req]
         * @Return: cn.com.duiba.tuia.adx.center.api.dto.consumer.ConsumerDto，没有返回null
         * @throws:
         * @author: youhaijun
         * @Date:   2017/12/13
         */
    ConsumerDto findFormalConsumer(ConsumerDto req);

    /***
         * @Description: updateConsumer 更新正式用户信息
         *
         * @Param: [req]
         * @Return: java.lang.Boolean
         * @throws:
         * @author: youhaijun
         * @Date:   2017/12/20
         */
    Boolean updateConsumer(ConsumerDto req);

    ConsumerDto getConsumerById(Long userId);

    /**
     * 获取下一个可用昵称
     * @param id 当用户已分配过昵称时，获取下一个昵称需要回传之前分配过的id，便于释放
     * @return
     */
    NickNameDto getNext(Long id);

    /**
     * 确认使用该昵称
     * @param nickName
     * @return
     */
    Boolean confirmNickName(String nickName);

    Boolean isUsedNickName(String nickName);

    Boolean insertAndUsedNickName(String nickName);
}
