package cn.com.duiba.tuia.adx.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.adx.center.api.dto.CouponsCodeDto;
import cn.com.duiba.tuia.adx.center.api.dto.PrizeDto;
import cn.com.duiba.tuia.adx.center.api.dto.RspTakeCoupon;
import cn.com.duiba.tuia.adx.center.api.dto.VirtualGoodsInfoDto;
import cn.com.duiba.tuia.adx.center.api.dto.prize.CoupleUploadStatusDto;
import cn.com.duiba.tuia.adx.center.api.dto.req.ReqVirtualRecharge;
import cn.com.duiba.tuia.adx.center.api.dto.req.SaveCouponReq;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 虚拟奖品服务
 */
@AdvancedFeignClient
public interface RemoteVirtualService {
	/**
	 * 虚拟商品API 充值
	 * @param req
	 * @return
	 */
	DubboResult<Boolean> recharge(ReqVirtualRecharge req);
	
	/**
	 * 管理端重发API充值
	 * @param orderIds 订单号列表
	 * @return
	 */
	DubboResult<Boolean> retry4Manager(List<Long> orderIds);
	
	/**
	 * 虚拟商品获取优惠券
	 * @param virtualId 虚拟商品id
	 * @return
	 */
	DubboResult<RspTakeCoupon> takeCoupon(String virtualId);

	/**
	 * 虚拟商品获取批次优惠券
	 * @param batchId 批次id
	 * @return
	 */
	DubboResult<RspTakeCoupon> takeBatchCoupon(String batchId);

	/**
	 * 
	 * getCouponsList:(获取劵码list). <br/>
	 *
	 * @author guyan
	 * @param prizeId 奖品id
	 * @param status 劵码状态
	 * @return
	 */
	DubboResult<List<CouponsCodeDto>> getCouponsList(Long prizeId,Integer status);
	
	/**
	 * 
	 * deleteCoupons:(删除劵码). <br/>
	 *
	 * @author guyan
	 * @param prizeId 奖品id
	 * @param status  劵码状态
	 * @param totalStock 总库存
	 * @return
	 */
	DubboResult<Boolean> deleteCoupons(Long prizeId,Integer status,Integer totalStock);
	
	/**
	 * updateStock:(修改库存). <br/>
	 *
	 * @author guyan
	 * @param dto 奖品dto
	 * @return
	 */
	DubboResult<Boolean> updateStock(PrizeDto dto);
	
	/**
	 * saveCoupons:(保存劵码). <br/>
	 *
	 * @author guyan
	 * @param list
	 * @return
	 */
	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="6000")
	DubboResult<Boolean> saveCoupons(List<CouponsCodeDto> list, Long prizeId,Long batchId, String start, String end,Integer isOld);

	/**
	 * 保存券码
	 * @param list 券码信息
	 * @param prizeId 奖品
	 * @return 数量
	 */
	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="6000")
	DubboResult<Integer> saveCouponsList(List<CouponsCodeDto> list,Long prizeId,Long batchId, String start, String end,Integer isOld);

	/**
	 *
	 * @param prizeId 奖品库Id
	 * @return 虚拟商品额外信息
	 */
	DubboResult<VirtualGoodsInfoDto> selectVirtualGoodsById(Long prizeId);

	/**
	 * 保存券码
	 * @param saveCouponReq 保存券码请求对象
	 * @return 数量
	 */
	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="6000")
	Boolean saveCouponsByReq(SaveCouponReq saveCouponReq);

	/**
	 * 保存券码
	 * saveCouponReq 保存券码请求对象
	 * @return 数量
	 */
	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="60000")
	Integer saveCouponsListByReq(SaveCouponReq saveCouponReq);


	/**
	 * 保存券码
	 * saveCouponReq 保存券码请求对象
	 * @return 数量
	 */
	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="60000")
	void saveCouponsListByReqV2(SaveCouponReq saveCouponReq);



	/**
	 * 获取异步上传奖券的状态
	 */
	CoupleUploadStatusDto resultUploadStatus( Long prizeId);


}
