package cn.com.duiba.tuia.adx.center.api.remoteservice.commercial.dig;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.commercial.CommercialUserReq;
import cn.com.duiba.tuia.adx.center.api.dto.commercial.dig.*;
import cn.com.duiba.tuia.adx.center.api.dto.commercial.mission.MissionConfigDto;
import cn.com.duiba.tuia.adx.center.api.dto.commercial.plant.StockLimitDto;

import java.util.ArrayList;
import java.util.List;

@AdvancedFeignClient
public interface RemoteDigService {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 用户信息  签到信息
     */
    DigDto sign(CommercialUserReq req) throws BizException;


    /**
     * 挖矿点击
     *
     * @param req      用户参数
     * @return 用户信息、任务信息，奖励信息
     */
    DigDto dig(DigClickReq req) throws BizException;



    /**
     * 挖矿点击
     * @param
     * @return 用户信息、任务信息，奖励信息
     */
    boolean updateDigNodePrizeConfig(Long appId, String configVersion, DigConfigDto configDto);


    /**
     *
     * @param req
     * @param missionId
     * @return
     * @throws BizException
     */
    DigDto finishMission(CommercialUserReq req, String missionId) throws BizException;


    List<ArrayList<Integer>> getTreasureList(CommercialUserReq req) throws BizException;


    /**
     * 更新任务配置
     * @param appId
     * @param configDto
     * @return
     */
    boolean updateDigMissionConfig(Long appId, MissionConfigDto configDto);


    /**
     * 更新层级配置
     */
    boolean updateLayerConfig(String version, List<DigLayerInfoDto> layerInfoDtos);

    StockLimitDto getStockLimitDto(Long userId);

    boolean updateStepsConfig(List<DigStepsConfigDto> digStepsConfigDto);

    /**
     * [测试用接口]清除缓存
     *
     * @param deviceId 设备id
     * @param appId 媒体id
     * @param date 签到日期
     */
    Boolean resetForTest(String deviceId, Long appId, String date);
}
