package cn.com.duiba.tuia.adx.center.api.util.holder;

import cn.com.duiba.tuia.adx.center.api.log.FullLinkLog;

import java.util.Objects;

/**
 * 全链路日志 线程变量 提供给上层服务使用
 * @author yuantong
 * @version 1.0
 * @since 2020-01-14 11:48
 */
public class FullLinkLogHolder {
    private static final ThreadLocal<FullLinkLog> FULL_LINK_HOLDER = new ThreadLocal<>();

    public static void set(FullLinkLog val) {
        FULL_LINK_HOLDER.set(val);
    }

    public static FullLinkLog getAndRemove() {
        FullLinkLog result = FULL_LINK_HOLDER.get();
        FULL_LINK_HOLDER.remove();
        return result;
    }

    public static FullLinkLog get() {
        final FullLinkLog holder = FULL_LINK_HOLDER.get();
        if(Objects.isNull(holder)){
            FULL_LINK_HOLDER.set(new FullLinkLog());
        }
        return FULL_LINK_HOLDER.get();
    }

    public static void remove() {
        FULL_LINK_HOLDER.remove();
    }
}
