/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.constant.commercial.mission;

import cn.com.duiba.tuia.adx.center.api.constant.commercial.mission.MissionCycleType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public enum MissionPrizeType {
    CASH(1, "CASH", "\u73b0\u91d1", 0, MissionCycleType.types()),
    LAND_UNLOCK(2, "LAND_UNLOCK", "\u89e3\u9501\u571f\u5730", 1, Collections.singletonList(0)),
    CORN_UNLOCK(3, "CORN_UNLOCK", "\u89e3\u9501\u7389\u7c73", 1, Collections.singletonList(0)),
    PUMPKIN_UNLOCK(4, "PUMPKIN_UNLOCK", "\u89e3\u9501\u5357\u74dc", 1, Collections.singletonList(0)),
    PITAYA_UNLOCK(5, "PITAYA_UNLOCK", "\u89e3\u9501\u706b\u9f99\u679c", 1, Collections.singletonList(0)),
    BLOCK(6, "BLOCK", "\u865a\u62df\u5956\u54c1", 0, MissionCycleType.types()),
    ENCOURAGE(7, "ENCOURAGE", "\u589e\u503c\u5e7f\u544a", 0, MissionCycleType.types()),
    VIDEO(8, "VIDEO", "\u89c6\u9891\u6fc0\u52b1\u5e7f\u544a", -1, Collections.emptyList()),
    FIRST_PRIZE(9, "FIRST_PRIZE", "\u65b0\u624b\u7ea2\u5305", -1, Collections.emptyList()),
    CASH_LANDING_SHOW(10, "CASH_LANDING_SHOW", "\u843d\u5730\u9875\u73b0\u91d1\u5956\u52b1", -1, Collections.emptyList()),
    CASH_LANDING_DOWNLOAD(11, "CASH_LANDING_DOWNLOAD", "\u843d\u5730\u9875\u73b0\u91d1\u5956\u52b1", -1, Collections.emptyList()),
    HEAVENLY_TREASURE_CHEST(12, "HEAVENLY_TREASURE_CHEST", "\u5929\u964d\u5b9d\u7bb1", -1, Collections.emptyList()),
    VAT_RED_RAIN(13, "VAT_RED_RAIN", "\u7ea2\u5305\u96e8", 0, MissionCycleType.types()),
    VAT_TREASURE_CHEST(14, "VAT_TREASURE_CHEST", "\u589e\u503c\u4efb\u52a1\u5b9d\u7bb1", 0, MissionCycleType.types()),
    KETTLE_UNLOCK(15, "KETTLE_UNLOCK", "\u89e3\u9501\u6c34\u58f6", -1, Collections.emptyList()),
    MANURE_UNLOCK(16, "MANURE_UNLOCK", "\u89e3\u9501\u80a5\u6599", -1, Collections.emptyList()),
    KETTLE(17, "KETTLE", "\u589e\u52a0\u6c34\u58f6\u6b21\u6570", -1, Collections.emptyList()),
    TREE_EXP(18, "TREE_EXP", "\u589e\u52a0\u6210\u957f\u503c", -1, Collections.emptyList()),
    MANURE(19, "MANURE", "\u589e\u52a0\u80a5\u6599\u6b21\u6570", -1, Collections.emptyList());

    private Integer type;
    private String key;
    private String desc;
    private Integer bizActivityType;
    private List<Integer> missionCycleTypes;

    private MissionPrizeType(Integer type, String key, String desc, Integer bizActivityType, List<Integer> missionCycleTypes) {
        this.type = type;
        this.key = key;
        this.desc = desc;
        this.bizActivityType = bizActivityType;
        this.missionCycleTypes = missionCycleTypes;
    }

    public Integer getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getBizActivityType() {
        return this.bizActivityType;
    }

    public List<Integer> getMissionCycleTypes() {
        return this.missionCycleTypes;
    }

    public static MissionPrizeType getByKey(String key) {
        for (MissionPrizeType typeEnum : MissionPrizeType.values()) {
            if (!Objects.equals(typeEnum.getKey(), key)) continue;
            return typeEnum;
        }
        return null;
    }

    public static Integer getTypeByKey(String key) {
        for (MissionPrizeType typeEnum : MissionPrizeType.values()) {
            if (!Objects.equals(typeEnum.getKey(), key)) continue;
            return typeEnum.getType();
        }
        return null;
    }

    public static String getKeyByType(Integer type) {
        for (MissionPrizeType typeEnum : MissionPrizeType.values()) {
            if (!Objects.equals(typeEnum.getType(), type)) continue;
            return typeEnum.getKey();
        }
        return null;
    }

    public static boolean isTypeExist(Integer type) {
        for (MissionPrizeType typeEnum : MissionPrizeType.values()) {
            if (!Objects.equals(typeEnum.getType(), type)) continue;
            return true;
        }
        return false;
    }
}

