package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.AdTypeDto;
import cn.com.duiba.tuia.adx.center.api.dto.AdxTypeDto;
import cn.com.duiba.tuia.adx.center.api.dto.IdAndNameDto;

import java.util.List;

/**
 * adx 样式服务
 *
 * @author peanut.huang
 * @date 2020/2/4 14:48
 */
@AdvancedFeignClient
public interface RemoteAdxStyleService {

   /**
    * 获取adx列表
    * @deprecated 下个版本发布可以删除, 请使用 {@link #obtainAdxListNew()}
    *
    * @return
    */
   @Deprecated
   List<IdAndNameDto> obtainAdxList();

   /**
    * 获取adx列表
    *
    */
   List<AdxTypeDto> obtainAdxListNew();

   /**
    * 获取广告样式
    *
    * @param adxType adx
    * @return
    */
   List<AdTypeDto> obtainStyle(Long adxType);
}
