package cn.com.duiba.tuia.adx.center.api.enums;

import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * adx平台类型
 *
 * @author weny.cai
 * @date 2019/1/3 15:46
 **/
public enum AdxTypeEnum {

    /**
     * 猎豹 ADX
     */
    LIEBAO(1, "猎豹", false,  "55287", "3",  false),

    /**
     * 搜狗 ADX
     */
    SOUGOU(2, "搜狗", false,  "56100", "10", false),

    /**
     * 墨迹天气 ADX
     */
    MOJI(3, "墨迹天气", false,  "57045", "11", false),

    /**
     * 暴风影音 ADX
     */
    BAOFENG(4, "暴风影音", false,  "58196", "18",  false),

    /**
     * 百度视频 ADX
     */
    BAIDU(5, "百度视频", true, "82999", "17", true),

    /**
     * 小米 ADX
     */
    XIAOMI(6, "小米", false,  "58972", "21",  false),

    /**
     * 掌阅 ADX
     */
    ZHANG_YUE(7, "掌阅", true,  "61112", "31",  false),

    /**
     * 2345 ADX
     */
    NAVIGATION(8, "2345", true,  "63596", "42",  false),

    /**
     * 连尚 ADX
     */
    LIAN_SHANG(9, "连尚", false,  "64738", "59",  false),

    /**
     * 小恩爱 ADX
     */
    XIAO_EN_AI(10, "小恩爱", true,  "63597", "71", false),

    /**
     * OPPO ADX
     */
    OPPO(11, "OPPO", true,  "66506", "84",  false),

    /**
     * 爱奇艺-联盟 ADX
     */
    I_QI_YI(12, "爱奇艺-联盟", true, "79712", "96", true),

    /**
     * MEIZU ADX
     */
    MEIZU(13, "魅族", true,  "68016", "94", false),

    /**
     * 芒果TV ADX
     */
    MONGO_TV(14, "芒果TV", true,  "69972", "124",  false),

    /**
     * apus ADX
     */
    APUS(15, "APUS", true,  "69989", "115", false),

    /**
     * 美数 ADX
     */
    MEI_SHU(16, "美数", true,  "69822", "118", false),

    /**
     * Lenovo ( 联想 ) ADX
     */
    LENOVO(17, "联想", true,  "70379", "125",  false),

    /**
     * 陌陌 ADX
     **/
    MOMO(18, "陌陌", true,  "70391", "119",  false),

    /**
     * Baidu Alliance ( 百度联盟 ) ADX
     */
    BAIDU_ALLIANCE(19, "百度联盟", false, "71092", "129",  false),

    /**
     * 中文万维
     **/
    IWANVI(20, "中文万维", false,  "71189", "130", false),

    /**
     * 陌陌开屏 ADX
     **/
    MOMO_OPEN_SCREEN(21, "陌陌开屏", false,  "71941", "134",  false),

    /**
     * 蜻蜓 ADX
     **/
    QINGTING(22, "蜻蜓", false,  "73007", "136",  false),

    /**
     * 京东金融 ADX
     **/
    JD_FINANCE(23, "京东金融", true,  "54751", "135", false),

    /**
     * 趣头条-其他系列 ADX
     **/
    QUTOUTIAO(24, "趣头条-其他系列", false,  "83064", "155",  false),

    /**
     * 软告 ADX
     **/
    RUAN_GAO(25, "软告", false,  "75699", "139", false),

    /**
     * 先荐 ADX
     **/
    XIAN_JIAN(26, "先荐", false,  "75695", "141", false),

    /**
     * 搜狐 ADX
     **/
    SOHU(27, "搜狐", true,  "76366", "140",  true),

    /**
     * 蜻蜓FM-2.0 ADX
     **/
    QINGTING_2(28, "蜻蜓2.0", false,  "73007", "143", false),

    /**
     * sigmob ADX
     **/
    SIGMOB(29, "sigmob", false,  "77448", "144",  false),

    /**
     * 爱奇艺-主站 ADX
     */
    I_QI_YI_MAIN(30, "爱奇艺-主站", true,  "68040", "151", true),

    /**
     * 芒果PDB ADX
     */
    MONGO_PDB(31, "芒果PDB", true,  "61642", "152", false),

    /**
     * 科大讯飞 ADX
     **/
    I_FLY_TEK(32, "IFlyTek", false,  "82110", "153",  false),


    INMOBI(33, "inmobi", false,  "82147", "154", false),


    /**
     * 趣头条-小说系列 ADX
     **/
    QUTOUTIAO_NOVEL(34, "趣头条-小说系列", false,  "82701", "157", false),


    FANCY(35, "泛为", false,  "83844", "158", false),

    KUAI_SHOU(36, "快手联盟", false,  "84766", "159", false),

    XIMALAYA(37, "喜马拉雅", false,  "85431", "165", false),

    QQ_READ(38, "QQ阅读", false,  "80611", "169", false),

    HUAWEI_ALLIANCE(39, "华为联盟", false, "86153", "170", false),

    YOUKU(40, "优酷", true, "83774", "171", false),

    ;


    private Integer type;

    private String name;

    /**
     * 是否需要审核
     */
    private Boolean needAudit;

    /**
     * 媒体ID
     **/
    private String mediaId;

    /**
     * 推广组ID
     **/
    private String groupId;

    /**
     * 广告主是否需要送审
     **/
    private Boolean advertiserNeedAudit;

    AdxTypeEnum(Integer type, String name, Boolean needAudit, String mediaId, String groupId, Boolean advertiserNeedAudit) {
        this.type = type;
        this.name = name;
        this.needAudit = needAudit;
        this.mediaId = mediaId;
        this.groupId = groupId;
        this.advertiserNeedAudit = advertiserNeedAudit;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public Boolean getNeedAudit() {
        return needAudit;
    }

    public String getMediaId() {
        return mediaId;
    }

    public String getGroupId() {
        return groupId;
    }

    public Boolean getAdvertiserNeedAudit() {
        return advertiserNeedAudit;
    }

    public boolean sameAdxType(Integer type) {
        return !Objects.isNull(type) && Objects.equals(this.type, type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type)
                ? null
                : Stream.of(AdxTypeEnum.values())
                .filter(item -> Objects.equals(item.getType(), type))
                .findFirst().orElse(null);
    }

    /**
     * 判断当前传入的adx类型是否需要审核
     *
     * @param adxType
     * @return
     */
    public static Boolean needAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType.equals(adxTypeEnum.getType())) {
                return adxTypeEnum.getNeedAudit();
            }
        }
        return false;
    }

    /**
     * 判断所有adx平台类型是否包含传入的adxType
     *
     * @param adxType
     * @return
     */
    public static Boolean contains(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType == adxTypeEnum.getType()) {
                return true;
            }
        }
        return false;
    }

    /**
     * 根据type获取平台类型
     *
     * @param type
     * @return
     */
    public static AdxTypeEnum getEnumByType(Integer type) {
        for (AdxTypeEnum typeEnum : AdxTypeEnum.values()) {
            if (type == typeEnum.getType()) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 根据adxName获取adxType
     *
     * @param adxName 名称
     * @return 编码值
     */
    public static Integer getAdxType(String adxName) {
        if (StringUtils.isBlank(adxName)) {
            return 0;
        }
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxTypeEnum.getName().equals(adxName)) {
                return adxTypeEnum.getType();
            }
        }
        return 0;
    }

    /**
     * 功能描述 判断广告主是否需要送审
     *
     * @param adxType
     * @return java.lang.Boolean
     * @author shenjiaqing
     * @date 17:17 2020/3/27
     **/
    public static Boolean advertiserNeedAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType.equals(adxTypeEnum.getType())) {
                return adxTypeEnum.getAdvertiserNeedAudit();
            }
        }
        return false;
    }

    public static List<Integer> getAllTypeList() {
        return Arrays.stream(AdxTypeEnum.values()).mapToInt(e -> e.getType()).boxed().collect(Collectors.toList());
    }

    /**
     * 创意需要送审的adx类型
     * @return
     */
    public static List<Integer> getAllNeedAudit() {
        List<Integer> needAudits = Lists.newArrayList();
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxTypeEnum.getNeedAudit()) {
                needAudits.add(adxTypeEnum.getType());
            }
        }
        return needAudits;
    }
}
