package cn.com.duiba.tuia.adx.center.api.util;


import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceLocationDto;
import org.apache.commons.lang3.StringUtils;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx相关工具类
 *
 * @author hillchen
 * @create 2019/2/24 16:16
 */
public class AdxUtils {
    private static final int YUN_FEN_CON = 100;

    private AdxUtils(){}

    /**
     * 转换为标准出价:1000/分，
     * 在数据库中存放的的数据单位为1000/元
     * @param resourceIdeaDto
     * @return
     */
    public static long convertParPrice(ResourceIdeaDto resourceIdeaDto){

        if(!Objects.isNull(resourceIdeaDto) && !Objects.isNull(resourceIdeaDto.getIdeaPrice())){
            return BigDecimal.valueOf(YUN_FEN_CON).multiply(BigDecimal.valueOf(resourceIdeaDto.getIdeaPrice())).longValue();
        }
        return 0;
    }

    /**
     * 转换为标准出价:1000/分，
     * 在数据库中存放的的数据单位为1000/元
     * @param dbPrice
     * @return
     */
    public static long convertParPrice(Double dbPrice){

        if(!Objects.isNull(dbPrice) ){
            return BigDecimal.valueOf(YUN_FEN_CON).multiply(BigDecimal.valueOf(dbPrice)).longValue();
        }
        return 0;
    }

    /**
     * 转换为标准出价:1000/分，
     * 在数据库中存放的的数据单位为1000/元
     * @param cpmPrice
     * @return
     */
    public static double convertParPriceToCpm(long cpmPrice){

        return BigDecimal.valueOf(cpmPrice).divide(BigDecimal.valueOf(YUN_FEN_CON),BigDecimal.ROUND_HALF_UP,2).doubleValue();
    }

    /**
     * 返回付费模式：0:cpc，1:cpm
     * @param resourceLocationDto
     * @return
     */
    public static int convertBillType(ResourceLocationDto resourceLocationDto){
        if(Objects.nonNull(resourceLocationDto) && StringUtils.isNotBlank(resourceLocationDto.getPayType())){
            if(StringUtils.equalsIgnoreCase("CPC",resourceLocationDto.getPayType())){
                return 0;
            }else if(StringUtils.equalsIgnoreCase("CPM",resourceLocationDto.getPayType())){
                return 1;
            }
        }
        return -1;
    }


}