/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.adx.center.api.enums;

import java.util.List;
import java.util.Objects;

/**
 * 描述: 推啊样式类型枚举
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/4/14 17:18
 */
public enum TuiaStyleTypeEnum {

    ONE_IMAGE(1, "单图"),

    TWO_IMAGE(2, "双图"),

    THREE_IMAGE(3, "三图"),

    VIDEO(4, "视频"),

    UNKNOWN(99, "未知"),

    ;

    private Integer code;

    private String value;

    public Integer getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    TuiaStyleTypeEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    /**
     * 根据推啊样式明细，获取推啊样式类型枚举
     *
     * @return
     */
    public static TuiaStyleTypeEnum transfer(List<Integer> materialTypeList) {
        Integer size = materialTypeList.size();
        TuiaStyleTypeEnum styleTypeEnum = TuiaStyleTypeEnum.UNKNOWN;
        switch (size) {
            case 1:
                styleTypeEnum = Objects.equals(materialTypeList.get(0), 1) ||
                        Objects.equals(materialTypeList.get(0), 0)?
                        TuiaStyleTypeEnum.ONE_IMAGE : TuiaStyleTypeEnum.VIDEO;
                return styleTypeEnum;
            case 2:
                styleTypeEnum = TuiaStyleTypeEnum.VIDEO;
                if (Objects.equals(materialTypeList.get(0), 1) &&
                        Objects.equals(materialTypeList.get(1), 1)) {
                    styleTypeEnum = TuiaStyleTypeEnum.TWO_IMAGE;
                }
                return styleTypeEnum;
            case 3:
                styleTypeEnum = TuiaStyleTypeEnum.UNKNOWN;
                if (Objects.equals(materialTypeList.get(0), 1) &&
                        Objects.equals(materialTypeList.get(1), 1) &&
                        Objects.equals(materialTypeList.get(2), 1)) {
                    styleTypeEnum = TuiaStyleTypeEnum.THREE_IMAGE;
                }
                return styleTypeEnum;
            default:
                return styleTypeEnum;
        }
    }
}
