package cn.com.duiba.tuia.adx.center.api.enums;

public enum AdvertiserAuditStatusEnum {

    WAIT(1,"待审核"),
    PASS(2,"审核通过"),
    REFUSE(3,"审核不通过"),
    ABNORMITY(4,"审核异常");

    private Integer code;

    private String description;

    AdvertiserAuditStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Integer getCode(String status){
        for(IQIYIAdvertiserAuditStatusEnum iqiyiAdvertiserAuditStatusEnum : IQIYIAdvertiserAuditStatusEnum.values()){
            if(iqiyiAdvertiserAuditStatusEnum.getStatus().equals(status)){
                return iqiyiAdvertiserAuditStatusEnum.getCode();
            }
        }
        return IQIYIAdvertiserAuditStatusEnum.WAIT.getCode();
    }
}
