/**
 * 
 */
package cn.com.duiba.tuia.adx.center.api.req;

import cn.com.duiba.tuia.adx.center.api.common.OrderBy;
import cn.com.duiba.tuia.adx.center.api.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * 此类描述的是： 分页查询条件.
 *
 * @author: leiliang
 * @version: 2016年2月18日 上午9:48:22
 */
public class ReqPageQuery extends BaseDto {
    private static final long serialVersionUID = -5791550885455703929L;

    /** 每页10条记录. */
    public static final int PAGE_SIZE_10    = 10;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_20    = 20;

    /** 每页50条记录. */
    public static final int PAGE_SIZE_50    = 50;

    /** 每页1000条记录. */
    public static final int PAGE_SIZE_1000    = 1000;

    /** 管理员ID，数据权限使用*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private Long            managerId;

    /** 管理员能查看的app列表*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private List<Long>      managerAppIds;

    /** 管理员能查看的用户列表*/
    @ApiModelProperty(value = "用户ID集合", required = false)
    private List<Long>      managerMediaIds;

    /** 起始记录数. */
    protected Integer         rowStart        = 0;

    /** 当前页. */
    protected Integer         currentPage     = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    protected Integer         pageSize;

    protected Date start;

    protected Date end;

    /** 排序字段(默认排序字段为：gmt_modified). */
    private String          sort;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    private String          order           = "desc";

    /**
     * 适用于多字段排序场景
     */
    private List<OrderBy> orderByList;

    /** 拼接字段查询使用*/
    @ApiModelProperty(value = "拼接字段", required = false)
    private String          conditionStr;

    public ReqPageQuery() {
        super();
    }

    public Date getStart() {
        return start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Integer getRowStart() {
        return rowStart;
    }

    public void setRowStart(Integer rowStart) {
        this.rowStart = rowStart;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public List<OrderBy> getOrderByList() {
        return orderByList;
    }

    public void setOrderByList(List<OrderBy> orderByList) {
        this.orderByList = orderByList;
    }

    public String getConditionStr() {
        return conditionStr;
    }

    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }

    public Long getManagerId() {
        return managerId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }

    public List<Long> getManagerAppIds() {
        return managerAppIds;
    }

    public void setManagerAppIds(List<Long> managerAppIds) {
        this.managerAppIds = managerAppIds;
    }

    public List<Long> getManagerMediaIds() {
        return managerMediaIds;
    }

    public void setManagerMediaIds(List<Long> managerMediaIds) {
        this.managerMediaIds = managerMediaIds;
    }
}
