package cn.com.duiba.tuia.adx.center.api.util;

/**
 * 描述：用于集卡
 *
 * @author weny.cai
 * @date 2018/10/11 14:16
 **/
public class CardCachedKeyUtils {

    /** The prefix. */
    private static String prefix = "card";

    /**
     * The Constructor.
     */
    private CardCachedKeyUtils() {

    }

    /**
     * Gets the prefix.
     *
     * @return the prefix
     */
    public static String getPrefix() {
        return prefix;
    }

    /**
     * Sets the prefix.
     *
     * @param prefix the prefix
     */
    public static void setPrefix(String prefix) {
        CardCachedKeyUtils.prefix = prefix;
    }

    /**
     * 获取redis缓存key.
     *
     * @param key CacheKey中定义的缓存key标识
     * @param params 需要加到key中的参数列表
     * @return redis key
     */
    public static String getRedisKey(String key, Object... params) {
        StringBuilder redisKey = new StringBuilder(getPrefix() + key);

        for (Object param : params) {
            redisKey.append("-" + param);
        }

        return redisKey.toString();
    }
}
