package cn.com.duiba.tuia.adx.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * Boolean 枚举
 * @dateTime 2019-10-18 15:51:27
 * @author haitao.hua
 */
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = true, chain = true, prefix = "")
public enum BooleanEnum {

    /*################################# Boolean 的枚举 ( Start ) #####################################*/

    True(1, true, "真"),
    False(2, false, "假");

    /*################################# Boolean 的枚举 ( end ) #######################################*/

    /**
     * 标识码
     */
    @Getter
    @Setter
    private Integer code;

    /**
     * 值
     */
    @Getter
    @Setter
    private Boolean value;

    /**
     * 备注
     */
    @Getter
    @Setter
    private String remark;

    /**
     * Seek 值
     * @param code 标识码
     * @return 结果
     */
    public static BooleanEnum seekValue(Integer code) {
        Optional<BooleanEnum> result = Arrays.stream(BooleanEnum.values()).filter(target -> (Objects.nonNull(target) && target.code.equals(code))).findFirst();
        return result.orElse(BooleanEnum.False);
    }

}
