package cn.com.duiba.tuia.adx.center.api.enums;

import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * adx平台类型
 *
 * @author weny.cai
 * @date 2019/1/3 15:46
 **/
public enum AdxTypeEnum {

    /**
     * 猎豹 ADX
     */
    LIEBAO(1, "猎豹", "55287", "3", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 搜狗 ADX
     */
    SOUGOU(2, "搜狗", "56100", "10", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 墨迹天气 ADX
     */
    MOJI(3, "墨迹天气", "57045", "11", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 暴风影音 ADX
     */
    BAOFENG(4, "暴风影音", "58196", "18", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 百度视频 ADX
     */
    BAIDU(5, "百度视频", "82999", "156", true, AuditTypeEnum.AUDIT.getCode()),

    /**
     * 小米 ADX
     */
    XIAOMI(6, "小米", "58972", "21", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 掌阅 ADX
     */
    ZHANG_YUE(7, "掌阅", "54876", "184", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 2345 ADX
     */
    NAVIGATION(8, "2345", "63596", "42", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 连尚 ADX
     */
    LIAN_SHANG(9, "连尚", "64738", "59", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 小恩爱 ADX
     */
    XIAO_EN_AI(10, "小恩爱", "63597", "71", false, AuditTypeEnum.AUDIT.getCode()),

    /**
     * OPPO ADX
     */
    OPPO(11, "OPPO", "66506", "84", false, AuditTypeEnum.AUDIT.getCode()),

    /**
     * 爱奇艺-联盟 ADX
     */
    I_QI_YI(12, "爱奇艺-联盟", "79712", "96", true, AuditTypeEnum.AUDIT.getCode()),

    /**
     * MEIZU ADX
     */
    MEIZU(13, "魅族", "68016", "94", false, AuditTypeEnum.AUDIT.getCode()),

    /**
     * 芒果TV ADX
     */
    MONGO_TV(14, "芒果TV", "69972", "124", false, AuditTypeEnum.AUDIT.getCode()),

    /**
     * apus ADX
     */
    APUS(15, "APUS", "69989", "115", false, AuditTypeEnum.AUDIT.getCode()),

    /**
     * 美数 ADX
     */
    MEI_SHU(16, "美数", "69822", "118", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * Lenovo ( 联想 ) ADX
     */
    LENOVO(17, "联想", "70379", "125", false, AuditTypeEnum.AUDIT.getCode()),

    /**
     * 陌陌 ADX
     **/
    MOMO(18, "陌陌", "70391", "119", false, AuditTypeEnum.AUDIT.getCode()),

    /**
     * Baidu Alliance ( 百度联盟 ) ADX
     */
    BAIDU_ALLIANCE(19, "百度联盟", "71092", "129", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 中文万维
     **/
    IWANVI(20, "中文万维", "71189", "130", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 陌陌开屏 ADX
     **/
    MOMO_OPEN_SCREEN(21, "陌陌开屏", "71941", "134", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 蜻蜓 ADX
     **/
    QINGTING(22, "蜻蜓", "73007", "136", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 京东金融 ADX
     **/
    JD_FINANCE(23, "京东金融", "54751", "135", false, AuditTypeEnum.AUDIT.getCode()),

    /**
     * 趣头条-其他系列 ADX
     **/
    QUTOUTIAO(24, "趣头条-其他系列", "83064", "155", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 软告 ADX
     **/
    RUAN_GAO(25, "软告", "75699", "139", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 先荐 ADX
     **/
    XIAN_JIAN(26, "先荐", "75695", "141", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 搜狐 ADX
     **/
    SOHU(27, "搜狐", "76366", "140", true, AuditTypeEnum.AUDIT.getCode()),

    /**
     * 蜻蜓FM-2.0 ADX
     **/
    QINGTING_2(28, "蜻蜓2.0", "73007", "143", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * sigmob ADX
     **/
    SIGMOB(29, "sigmob", "77448", "144", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    /**
     * 爱奇艺-主站 ADX
     */
    I_QI_YI_MAIN(30, "爱奇艺-主站", "68040", "151", true, AuditTypeEnum.AUDIT.getCode()),

    /**
     * 芒果PDB ADX
     */
    MONGO_PDB(31, "芒果PDB", "61642", "152", false, AuditTypeEnum.AUDIT.getCode()),

    /**
     * 科大讯飞 ADX
     **/
    I_FLY_TEK(32, "IFlyTek", "82110", "153", false, AuditTypeEnum.FREE_AUDIT.getCode()),


    INMOBI(33, "inmobi", "82147", "154", false, AuditTypeEnum.FREE_AUDIT.getCode()),


    /**
     * 趣头条-小说系列 ADX
     **/
    QUTOUTIAO_NOVEL(34, "趣头条-小说系列", "82701", "157", false, AuditTypeEnum.FREE_AUDIT.getCode()),


    FANCY(35, "泛为", "83844", "158", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    KUAI_SHOU(36, "快手联盟", "84766", "159", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    XIMALAYA(37, "喜马拉雅", "85431", "165", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    QQ_READ(38, "QQ阅读", "80611", "169", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    HUAWEI_ALLIANCE(39, "华为联盟", "86153", "170", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    YOUKU(40, "优酷", "83774", "171", false, AuditTypeEnum.AUDIT.getCode()),

    CHU_BAO(41, "触宝", "89596", "183", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    QB(42, "腾讯Q系", "89829", "185", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    X_MILES(43, "小迈", "89876", "187", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    TUIA(44, "推啊", "86888", "189", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    YIDIANZIXUN(45, "一点资讯", "86888", "227", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    //仅用来占类型打印竞价请求参数
    MEITUAN(46, "美团", "-1", "-1", false, AuditTypeEnum.AUDIT.getCode()),

    adscope(47, "adscope", "93845", "544", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    ubix(48, "ubix", "95090", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    KUAISHOU_MASTER(49, "快手巨网", "96465", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    YUN_MA(50, "云码", "0", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    TUIA_ADX(51, "tuiaAdx", "0", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    HUAWEI_ADX(52, "huaweiAdx", "86153", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    ZHANG_YU(53, "章鱼", "96319", "574", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    JXEDT(54, "驾校一点通", "96782", "575", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    YDTX(55, "易点天下", "96933", "576", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    ZHWNL(56, "中华万年历", "97149", "577", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    WYY(57, "网易云音乐", "97179", "578", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    QIMAO(58, "七猫", "97130", "579", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    SYXJ(59, "水印相机", "97130", "580", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    TOPON(60, "TOPON", "97158", "653", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    LE_YOU_QI(61, "乐优启", "97500", "654", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    WU_BAI(62, "500网", "97606", "655", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    FEI_SUO(63, "飞梭", "97538", "656", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    DE_JIAN(64, "得间", "97551", "657", false, AuditTypeEnum.FREE_AUDIT.getCode()),

    B612(65, "B612", "97551", "658", false, AuditTypeEnum.FREE_AUDIT.getCode()),
    ;


    private Integer type;

    private String name;

    /**
     * 媒体ID
     **/
    private String mediaId;

    /**
     * 推广组ID
     **/
    private String groupId;

    /**
     * 广告主是否需要送审
     **/
    private Boolean advertiserNeedAudit;

    /**
     * 审核方式
     */
    private Integer auditType;

    AdxTypeEnum(Integer type, String name, String mediaId, String groupId, Boolean advertiserNeedAudit, Integer auditType) {
        this.type = type;
        this.name = name;
        this.mediaId = mediaId;
        this.groupId = groupId;
        this.advertiserNeedAudit = advertiserNeedAudit;
        this.auditType = auditType;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public String getMediaId() {
        return mediaId;
    }

    public String getGroupId() {
        return groupId;
    }

    public Boolean getAdvertiserNeedAudit() {
        return advertiserNeedAudit;
    }

    public Integer getAuditType() {
        return auditType;
    }

    public boolean sameAdxType(Integer type) {
        return !Objects.isNull(type) && Objects.equals(this.type, type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type) ? null : Stream.of(AdxTypeEnum.values()).filter(item -> Objects.equals(item.getType(), type)).findFirst().orElse(null);
    }

    /**
     * 判断当前传入的adx类型是否需要审核
     *
     * @param adxType
     * @return
     */
    public static Boolean needAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType.equals(adxTypeEnum.getType())) {
                return Objects.equals(adxTypeEnum.getAuditType(), AuditTypeEnum.AUDIT.getCode());
            }
        }
        return false;
    }

    /**
     * 判断所有adx平台类型是否包含传入的adxType
     *
     * @param adxType
     * @return
     */
    public static Boolean contains(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType == adxTypeEnum.getType()) {
                return true;
            }
        }
        return false;
    }

    /**
     * 根据type获取平台类型
     *
     * @param type
     * @return
     */
    public static AdxTypeEnum getEnumByType(Integer type) {
        for (AdxTypeEnum typeEnum : AdxTypeEnum.values()) {
            if (type == typeEnum.getType()) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 根据adxName获取adxType
     *
     * @param adxName 名称
     * @return 编码值
     */
    public static Integer getAdxType(String adxName) {
        if (StringUtils.isBlank(adxName)) {
            return 0;
        }
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxTypeEnum.getName().equals(adxName)) {
                return adxTypeEnum.getType();
            }
        }
        return 0;
    }

    /**
     * 功能描述 判断广告主是否需要送审
     *
     * @param adxType
     * @return java.lang.Boolean
     * @author shenjiaqing
     * @date 17:17 2020/3/27
     **/
    public static Boolean advertiserNeedAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType.equals(adxTypeEnum.getType())) {
                return adxTypeEnum.getAdvertiserNeedAudit();
            }
        }
        return false;
    }

    public static List<Integer> getAllTypeList() {
        return Arrays.stream(AdxTypeEnum.values()).mapToInt(e -> e.getType()).boxed().collect(Collectors.toList());
    }

    /**
     * 创意需要送审的adx类型
     *
     * @return
     */
    public static List<Integer> getAllNeedAudit() {
        List<Integer> needAudits = Lists.newArrayList();
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (needAudit(adxTypeEnum.getType())) {
                needAudits.add(adxTypeEnum.getType());
            }
        }
        return needAudits;
    }
}
