/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.dto;

import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceStyleDetailDto;
import cn.com.duiba.tuia.adx.center.api.dto.AdvertisingSpaceStyleMaterialDto;
import cn.com.duiba.tuia.adx.center.api.dto.MaterialUnitDescFilter;
import cn.com.duiba.tuia.adx.center.api.dto.MaterialUnitDetailFilter;
import cn.com.duiba.tuia.adx.center.api.dto.MaterialUnitTitleFilter;
import cn.com.duiba.tuia.adx.center.api.enums.TuiaStyleTypeEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public class MaterialUnitFilterCondition
implements Serializable {
    private static final long serialVersionUID = 9081345423518807603L;
    private TuiaStyleTypeEnum tuiaStyleTypeEnum;
    private MaterialUnitTitleFilter materialUnitTitleFilter;
    private MaterialUnitDescFilter materialUnitDescFilter;
    private List<MaterialUnitDetailFilter> materialUnitDetailFilterList;

    public MaterialUnitFilterCondition(TuiaStyleTypeEnum tuiaStyleTypeEnum) {
        this.tuiaStyleTypeEnum = tuiaStyleTypeEnum;
    }

    public MaterialUnitFilterCondition(MaterialUnitTitleFilter titleFilter, MaterialUnitDescFilter descFilter, List<MaterialUnitDetailFilter> detailFilterList) {
        this.materialUnitTitleFilter = titleFilter;
        this.materialUnitDescFilter = descFilter;
        this.materialUnitDetailFilterList = detailFilterList;
    }

    public MaterialUnitFilterCondition setCommonStyle(TuiaStyleTypeEnum styleTypeEnum) {
        this.tuiaStyleTypeEnum = styleTypeEnum;
        return this;
    }

    public static MaterialUnitFilterCondition transfer(AdvertisingSpaceStyleDetailDto adStyleDto, List<AdvertisingSpaceStyleMaterialDto> adStyleMaterialList) {
        if (adStyleDto == null || CollectionUtils.isEmpty(adStyleMaterialList)) {
            return new MaterialUnitFilterCondition(TuiaStyleTypeEnum.UNKNOWN);
        }
        Integer size = adStyleDto.getNum();
        MaterialUnitTitleFilter titleFilter = (MaterialUnitTitleFilter)BeanUtils.copy((Object)adStyleDto, MaterialUnitTitleFilter.class);
        MaterialUnitDescFilter descFilter = (MaterialUnitDescFilter)BeanUtils.copy((Object)adStyleDto, MaterialUnitDescFilter.class);
        ArrayList detailFilterList = Lists.newArrayList();
        adStyleMaterialList.forEach(adStyleMaterialDto -> {
            MaterialUnitDetailFilter detailFilter = (MaterialUnitDetailFilter)BeanUtils.copy((Object)adStyleMaterialDto, MaterialUnitDetailFilter.class);
            detailFilter.setMaterialType(adStyleMaterialDto.getType());
            detailFilter.setSize(Objects.equals(adStyleMaterialDto.getUnit(), "KB") ? (long)adStyleMaterialDto.getSize().intValue() : (long)adStyleMaterialDto.getSize().intValue() * 1024L);
            detailFilterList.add(detailFilter);
        });
        MaterialUnitFilterCondition materialUnitFilter = new MaterialUnitFilterCondition(titleFilter, descFilter, detailFilterList);
        TuiaStyleTypeEnum styleTypeEnum = TuiaStyleTypeEnum.UNKNOWN;
        switch (size) {
            case 1: {
                styleTypeEnum = Objects.equals(adStyleMaterialList.get(0).getType(), 1) ? TuiaStyleTypeEnum.ONE_IMAGE : TuiaStyleTypeEnum.VIDEO;
                return materialUnitFilter.setCommonStyle(styleTypeEnum);
            }
            case 2: {
                styleTypeEnum = TuiaStyleTypeEnum.VIDEO;
                if (Objects.equals(adStyleMaterialList.get(0).getType(), 1) && Objects.equals(adStyleMaterialList.get(1).getType(), 1)) {
                    styleTypeEnum = TuiaStyleTypeEnum.TWO_IMAGE;
                }
                return materialUnitFilter.setCommonStyle(styleTypeEnum);
            }
            case 3: {
                styleTypeEnum = TuiaStyleTypeEnum.UNKNOWN;
                if (Objects.equals(adStyleMaterialList.get(0).getType(), 1) && Objects.equals(adStyleMaterialList.get(1).getType(), 1) && Objects.equals(adStyleMaterialList.get(2).getType(), 1)) {
                    styleTypeEnum = TuiaStyleTypeEnum.THREE_IMAGE;
                }
                return materialUnitFilter.setCommonStyle(styleTypeEnum);
            }
        }
        return materialUnitFilter.setCommonStyle(styleTypeEnum);
    }

    public TuiaStyleTypeEnum getTuiaStyleTypeEnum() {
        return this.tuiaStyleTypeEnum;
    }

    public MaterialUnitTitleFilter getMaterialUnitTitleFilter() {
        return this.materialUnitTitleFilter;
    }

    public MaterialUnitDescFilter getMaterialUnitDescFilter() {
        return this.materialUnitDescFilter;
    }

    public List<MaterialUnitDetailFilter> getMaterialUnitDetailFilterList() {
        return this.materialUnitDetailFilterList;
    }

    public void setTuiaStyleTypeEnum(TuiaStyleTypeEnum tuiaStyleTypeEnum) {
        this.tuiaStyleTypeEnum = tuiaStyleTypeEnum;
    }

    public void setMaterialUnitTitleFilter(MaterialUnitTitleFilter materialUnitTitleFilter) {
        this.materialUnitTitleFilter = materialUnitTitleFilter;
    }

    public void setMaterialUnitDescFilter(MaterialUnitDescFilter materialUnitDescFilter) {
        this.materialUnitDescFilter = materialUnitDescFilter;
    }

    public void setMaterialUnitDetailFilterList(List<MaterialUnitDetailFilter> materialUnitDetailFilterList) {
        this.materialUnitDetailFilterList = materialUnitDetailFilterList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialUnitFilterCondition)) {
            return false;
        }
        MaterialUnitFilterCondition other = (MaterialUnitFilterCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TuiaStyleTypeEnum this$tuiaStyleTypeEnum = this.getTuiaStyleTypeEnum();
        TuiaStyleTypeEnum other$tuiaStyleTypeEnum = other.getTuiaStyleTypeEnum();
        if (this$tuiaStyleTypeEnum == null ? other$tuiaStyleTypeEnum != null : !((Object)((Object)this$tuiaStyleTypeEnum)).equals((Object)other$tuiaStyleTypeEnum)) {
            return false;
        }
        MaterialUnitTitleFilter this$materialUnitTitleFilter = this.getMaterialUnitTitleFilter();
        MaterialUnitTitleFilter other$materialUnitTitleFilter = other.getMaterialUnitTitleFilter();
        if (this$materialUnitTitleFilter == null ? other$materialUnitTitleFilter != null : !((Object)this$materialUnitTitleFilter).equals(other$materialUnitTitleFilter)) {
            return false;
        }
        MaterialUnitDescFilter this$materialUnitDescFilter = this.getMaterialUnitDescFilter();
        MaterialUnitDescFilter other$materialUnitDescFilter = other.getMaterialUnitDescFilter();
        if (this$materialUnitDescFilter == null ? other$materialUnitDescFilter != null : !((Object)this$materialUnitDescFilter).equals(other$materialUnitDescFilter)) {
            return false;
        }
        List<MaterialUnitDetailFilter> this$materialUnitDetailFilterList = this.getMaterialUnitDetailFilterList();
        List<MaterialUnitDetailFilter> other$materialUnitDetailFilterList = other.getMaterialUnitDetailFilterList();
        return !(this$materialUnitDetailFilterList == null ? other$materialUnitDetailFilterList != null : !((Object)this$materialUnitDetailFilterList).equals(other$materialUnitDetailFilterList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialUnitFilterCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TuiaStyleTypeEnum $tuiaStyleTypeEnum = this.getTuiaStyleTypeEnum();
        result = result * 59 + ($tuiaStyleTypeEnum == null ? 43 : ((Object)((Object)$tuiaStyleTypeEnum)).hashCode());
        MaterialUnitTitleFilter $materialUnitTitleFilter = this.getMaterialUnitTitleFilter();
        result = result * 59 + ($materialUnitTitleFilter == null ? 43 : ((Object)$materialUnitTitleFilter).hashCode());
        MaterialUnitDescFilter $materialUnitDescFilter = this.getMaterialUnitDescFilter();
        result = result * 59 + ($materialUnitDescFilter == null ? 43 : ((Object)$materialUnitDescFilter).hashCode());
        List<MaterialUnitDetailFilter> $materialUnitDetailFilterList = this.getMaterialUnitDetailFilterList();
        result = result * 59 + ($materialUnitDetailFilterList == null ? 43 : ((Object)$materialUnitDetailFilterList).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialUnitFilterCondition(tuiaStyleTypeEnum=" + (Object)((Object)this.getTuiaStyleTypeEnum()) + ", materialUnitTitleFilter=" + this.getMaterialUnitTitleFilter() + ", materialUnitDescFilter=" + this.getMaterialUnitDescFilter() + ", materialUnitDetailFilterList=" + this.getMaterialUnitDetailFilterList() + ")";
    }

    public MaterialUnitFilterCondition() {
    }

    public MaterialUnitFilterCondition(TuiaStyleTypeEnum tuiaStyleTypeEnum, MaterialUnitTitleFilter materialUnitTitleFilter, MaterialUnitDescFilter materialUnitDescFilter, List<MaterialUnitDetailFilter> materialUnitDetailFilterList) {
        this.tuiaStyleTypeEnum = tuiaStyleTypeEnum;
        this.materialUnitTitleFilter = materialUnitTitleFilter;
        this.materialUnitDescFilter = materialUnitDescFilter;
        this.materialUnitDetailFilterList = materialUnitDetailFilterList;
    }
}

