package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.MaterialLibDTO;
import cn.com.duiba.tuia.adx.center.api.dto.UserMaterialLibDTO;
import cn.com.duiba.tuia.adx.center.api.req.*;

import java.util.List;

/**
 * @author lizhiheng
 * @date 2022/1/10 3:38 下午
 */
@AdvancedFeignClient
public interface RemoteMaterialLibService {
    /**
     * 获取素材库列表
     *
     * @return
     */
    List<UserMaterialLibDTO> getList(Long adminId,Integer permission);

    /**
     * 新增素材库
     */
    boolean add(MaterialLibAddReq materialLibAddReq);

    /**
     * 素材库分享
     *
     * @return
     */
    boolean share(MaterialLibShareReq req);

    /**
     * 同步素材库
     */
    boolean sync(MaterialLibSyncReq materialLibSyncReq);

    /**
     * 更新素材库
     */
    boolean update(MaterialLibUpdateReq materialLibUpdateReq);

    /**
     * 删除素材库
     */
    boolean delete(MaterialLibDeleteReq materialLibDeleteReq) throws BizException;

    List<MaterialLibDTO> allLib();

}
