package cn.com.duiba.tuia.adx.center.api.dto;

import cn.com.duiba.tuia.adx.center.api.enums.IdeaBidTypeEnum;
import cn.com.duiba.tuia.adx.center.api.enums.UnitPutTypeEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 创意
 *
 * @author weny.cai
 * @date 2018/12/3 14:27
 **/
@Data
@ToString
public class ResourceIdeaDto implements Serializable {

    private static final long serialVersionUID = 2078063159077522207L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 资源位id
     */
    private Long resourceId;

    /**
     * 创意名称
     */
    private String ideaName;

    /**
     * 创意计划开关：0，关闭；1，开启
     */
    private Integer switchState;

    /**
     * 推啊广告位id
     */
    private Long slotId;

    private String ideaTitle;

    private String ideaDesc;

    private Integer budgetType;

    private Double dayBudget;

    private String dayBudgetStr;

    /**
     * 出价（元/CPM）
     */
//    private Double ideaPrice;

    /**
     * 出价（元/CPM）
     */
//    private String ideaPriceStr;

    private String resourceName;

    private String groupName;

    private Long groupId;

    private Integer adxType;

    private Integer sysState;
    /**
     * 手机品牌名称
     */
    private String brandName;
    /**
     * 机型
     */
    private String phoneModel;

    private List<String> sysValue;

    private List<String> sysVersion;

    private Date gmtCreate;

    private Date gmtModified;

    private ResourceLocationDto resourceLocationDto;

    private List<IdeaPictureDto> ideaPictureDtos;

    /*
     * 创意视频
     */
    private IdeaVideoDto ideaVideo;

    private Integer exposurePv;

    private Integer clickPv;

    /**
     * 消耗
     */
    private String price;

    /**
     * 创意广告消耗
     */
    private BigDecimal income;

    private String clickRate;

    /**
     * 点击率显示文本
     */
    private String ctrText;

    /**
     * 平均扣费
     */
    private String agvPrice;

    //页面查询时的cpc价格
    private String cpcPrice;

    /**
     * 出价类型类型 0--固价cpm 1--基于底价 2--百度CPC 3--百度OCPM
     */
    private Integer priceType;
    /**
     * 计费类型  1:cpm  3:ocpm 4:定制 0-cpc(废弃) 2-cps rtb不展示
     */
    private Integer chargeType;

    /**
     * 分成比例
     */
    private Double shareRatio;

    /**
     * roi维稳
     */
    private Integer roiState;

    /**
     * 目标ROI
     */
    private Double minRoi;

    /**
     * 最小创意出价：包含
     */
    private Double minPrice;

    /**
     * cpc控制 0-关闭 1-开启
     */
    private Integer cpcState;

    /**
     * 最大创意出价：包含
     */
    private Double maxPrice;

    private Integer timesLimitFlag;

    private Integer timesLimitType;

    private Integer limitNum;

    /**
     * 创意审核状态
     */
    private List<ResourceIdeaAuditDto> resourceIdeaAuditDtoList;
    /**
     * 可投资源位列表
     */
    private List<ShortResourceLocationDto> enableResourceLocations;


    /**
     * 投放地域（0：不限，1：自定义）默认0
     */
    private Integer putAreaType;

    /**
     * 区域码（多个以逗号拼接）
     */
    private String areaCode;

    /**
     * 广告位样式ID
     **/
    private Long adStyleId;

    /**
     * 广告位样式模版ID
     **/
    private String templateId;

    private String styleName;

    /**
     * 地域码集合
     */
    private List<Long> areaCodeList;

    /**
     * 创意竞价类型：0:互动 1：直投 {@link IdeaBidTypeEnum}
     */
    private Integer bidType;

    /**
     * Dsp 平台Id
     */
    private Integer dspId;

    /**
     * dsp 模版id 对应前端DSP样式id
     */
    private String dspTemplateId;

    /**
     * dsp 广告位id
     */
    private String dspTagId;

    /**
     * dsp 资源位id
     */
    private String dspResId;

    /**
     * 广告主id
     */
    private Integer advertiserId;

    /**
     * 广告id
     */
    private Integer advertId;

    /**
     * PMP投放类型，0:RTB，1:PD，2:PDB
     *
     * @see cn.com.duiba.tuia.adx.center.api.enums.PmpType
     */
    private Integer pmpType;

    /**
     * 页面查询时的当前roi
     */
    private Double roi;

    /**
     * 创意出价策略(只在查询单个创意的时候返回，列表的时候注意为空)
     */
    private IdeaPriceStrategyDTO ideaPriceStrategyDTO;

    /**
     * 曝光频次等级：0.不限 1.强 2.中 3.弱
     */
    private Integer frequencyLevel;

    /**
     * 点击频次等级：0.不限 1.强 2.中 3.弱
     */
    private Integer clickFrequencyLevel;

    /**
     * 首次进入限制强弱等级：0.不限 1.强 2.中 3.弱
     *
     * @see cn.com.duiba.tuia.adx.center.api.enums.RequestFilterLevelEnum
     */
    private Integer requestFilterLevel;

    /**
     * 是否开启dpa,0:不开启 1：开启
     */
    private Integer dpaFlag;

    /**
     * dmp人群定向包
     */
    private List<ResourceIdeaCrowdBindDto> orientationCrowds;

    private Set<Integer> orientationCrowdTypes;

    private List<ResourceIdeaCrowdBindDto> excludeCrowds;

    private Set<Integer> excludeCrowdTypes;

    private Set<Integer> crowdTypes;

    /**
     * adx人群定向包
     */
    private List<ResourceIdeaCrowdBindDto> adxOrientationCrowds;

    private Set<Integer> adxOrientationCrowdTypes;

    private List<ResourceIdeaCrowdBindDto> adxExcludeCrowds;

    private Set<Integer> adxExcludeCrowdTypes;

    private Set<Integer> adxCrowdTypes;

    /**
     * 媒体人群定向包
     */

    private List<ResourceIdeaCrowdBindDto> mediaOrientationCrowds;

    private Set<Integer> mediaOrientationCrowdTypes;

    private List<ResourceIdeaCrowdBindDto> mediaExcludeCrowds;

    private Set<Integer> mediaExcludeCrowdTypes;

    private Set<Integer> mediaCrowdTypes;

    private Integer crowdBindType;  //1 不限  2 自定义

    private Integer crowdBindLogicType; //1 定向 2 排除  3 定向+排除

    private Integer adxCrowdBindType;  //1 不限  2 自定义

    private Integer adxCrowdBindLogicType;//1 定向 2 排除  3 定向+排除

    private Integer mediaCrowdBindType;  //1 不限  2 自定义

    private Integer mediaCrowdBindLogicType; //1 定向 2 排除  3 定向+排除

    //广告行为人群定向包
    private Integer adActionBindType;  //1 不限  2 自定义

    private Integer adActionBindLogicType; //1 定向 2 排除  3 定向+排除

    /**
     * pd预算类型
     */
    private Integer pdbBudgetType;

    /**
     * pd每日预算
     */
    private Double pdbDayBudget;

    /**
     * pd出价类型
     */
    private Integer pdbPriceType;

    /**
     * 是否新架构4.0 0/null-否 1-是
     */
    private Integer isNew;

    /**
     * 创意素材投放方式 1-人工 2-算法
     *
     * @see UnitPutTypeEnum
     */
    private Integer unitPutType;

    /**
     * 素材库id
     */
    private Long materialLibId;

    /**
     * 创意素材ID展示明细
     */
    private List<MaterialUnitDTO> materialUnitDTOList;

    /**
     * 创意计划多样式
     */
    private List<Long> adStyleIdList;

    /**
     * 投放时间-开始
     */
    private String startDate;

    /**
     * 投放时间-截止
     */
    private String endDate;

    /**
     * 投放时间段
     */
    private String timePeriod;

    /**
     * 投放时间段
     */
    private List<ResourceTimeDto> timeDtos;

    /**
     * 平均扣费
     */
    private String ideaAvgPriceStr;

    /**
     * 资源计划标签对象集合
     */
    private List<ResourceIdeaTagRelationDto> tagRelationData;

    /**
     * 创意计划投放比例
     */
    private Integer deliveryRatio;

    /**
     * 投放管理开关：0.关闭；1.开启
     */
    private Integer deliveryManageSwitch;

    /**
     * 创意名称通配符
     */
    private String ideaNameWildcard;

    private Integer strategyType;

    private Double expectPrice;

    /**
     * 互动链路类型 0 传统互动  1 首发券互动
     */
    private Integer interactLinkType;

    /**
     * 是否定向设备用户：0 否 1 是（DeviceOrientTypeEnum）
     */
    private Integer deviceOrientType;

    /**
     * 素材开启人工投放 0 关闭  1开启
     */
    private Integer unitRandomState;

    /**
     * 素材人工投放比例
     */
    private Integer unitRandomRatio;

    /**
     * 广告行为人群定向包
     */
    private List<ResourceIdeaCrowdBindDto> adActionOrientationCrowds;

    /**
     * 广告行为人群排除包
     */
    private List<ResourceIdeaCrowdBindDto> adActionExcludeCrowds;

    /**
     * 外部dsp素材类型 1 dsp  2tuia
     */
    private Integer dspUnitType;

    /**
     * 流量价格过滤 0不限 1自定义
     */
    private Integer flowPriceState;

    /**
     * 流量最低价格 单位 元
     */
    private Double flowMinPrice;

    /**
     * 流量最高价格 单位 元
     */
    private Double flowMaxPrice;

    /**
     * 送审地址
     */
    private String auditUrl;

    /**
     * 媒体白名单 0不限 1自定义
     */
    private Integer mediaWhiteType;

    /**
     * 媒体黑名单 0不限 1自定义
     */
    private Integer mediaBlackType;

    /**
     * 媒体广告位定向 0不限 1自定义
     */
    private Integer posBindType;


    /**
     * 白名单媒体列表
     */
    List<String> orientationMedias;

    /**
     * 黑名单媒体列表
     */
    List<String> excludeMedias;

    /**
     * 绑定广告位列表
     */
    List<String> posIds;

}

